/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CreatePackageInfoAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingPackageInfoInspection
extends BaseGlobalInspection {
    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalMissingPackageInfoInspection(this);
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        String packageName = refPackage.getQualifiedName();
        Project project = globalContext.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (MissingPackageInfoInspection.hasPackageInfoFile(aPackage)) {
            return null;
        }
        List children = refPackage.getChildren();
        boolean hasClasses = false;
        for (RefEntity child : children) {
            if (!(child instanceof RefClass)) continue;
            hasClasses = true;
            break;
        }
        if (!hasClasses) {
            return null;
        }
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)aPackage)) {
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("missing.package.info.problem.descriptor", packageName), new QuickFix[0])};
        }
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("missing.package.html.problem.descriptor", packageName), new QuickFix[0])};
    }

    @Contract(value="null -> true")
    static boolean hasPackageInfoFile(PsiPackage aPackage) {
        PsiDirectory[] directories;
        if (aPackage == null) {
            return true;
        }
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            boolean packageDotHtmlFound;
            boolean packageInfoFound = directory.findFile("package-info.java") != null;
            boolean bl = packageDotHtmlFound = directory.findFile("package.html") != null;
            if (!packageInfoFound && !packageDotHtmlFound) continue;
            return true;
        }
        return false;
    }

    private static class LocalMissingPackageInfoInspection
    extends BaseSharedLocalInspection<MissingPackageInfoInspection> {
        LocalMissingPackageInfoInspection(MissingPackageInfoInspection settingsDelegate) {
            super(settingsDelegate);
        }

        @Override
        @Nullable
        protected InspectionGadgetsFix buildFix(Object ... infos) {
            return new InspectionGadgetsFix(){

                @NotNull
                public String getFamilyName() {
                    return InspectionGadgetsBundle.message("create.package.info.java.family.name", new Object[0]);
                }

                public boolean startInWriteAction() {
                    return false;
                }

                @Override
                protected void doFix(Project project, ProblemDescriptor descriptor) {
                    DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                        AnActionEvent event = new AnActionEvent(null, context, "", new Presentation(), ActionManager.getInstance(), 0);
                        new CreatePackageInfoAction().actionPerformed(event);
                    });
                }
            };
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            PsiPackageStatement packageStatement = (PsiPackageStatement)infos[0];
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)packageStatement)) {
                return InspectionGadgetsBundle.message("missing.package.info.problem.descriptor", packageStatement.getPackageName());
            }
            return InspectionGadgetsBundle.message("missing.package.html.problem.descriptor", packageStatement.getPackageName());
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new BaseInspectionVisitor(){

                public void visitJavaFile(PsiJavaFile file) {
                    PsiPackageStatement packageStatement = file.getPackageStatement();
                    if (packageStatement == null) {
                        return;
                    }
                    PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
                    PsiElement target = packageReference.resolve();
                    if (!(target instanceof PsiPackage)) {
                        return;
                    }
                    PsiPackage aPackage = (PsiPackage)target;
                    if (MissingPackageInfoInspection.hasPackageInfoFile(aPackage)) {
                        return;
                    }
                    this.registerError((PsiElement)packageReference, packageStatement);
                }
            };
        }
    }
}

