/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleCharacterStartsWithInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("single.character.startswith.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SingleCharacterStartsWithFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SingleCharacterStartsWithVisitor();
    }

    private static class SingleCharacterStartsWithVisitor
    extends BaseInspectionVisitor {
        private SingleCharacterStartsWithVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"startsWith".equals(methodName) && !"endsWith".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1 && args.length != 2) {
                return;
            }
            if (!SingleCharacterStartsWithVisitor.isSingleCharacterStringLiteral(args[0])) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static boolean isSingleCharacterStringLiteral(PsiExpression arg) {
            PsiType type2 = arg.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return false;
            }
            if (!(arg instanceof PsiLiteralExpression)) {
                return false;
            }
            PsiLiteralExpression literal = (PsiLiteralExpression)arg;
            String value2 = (String)literal.getValue();
            return value2 != null && value2.length() == 1;
        }
    }

    private static class SingleCharacterStartsWithFix
    extends InspectionGadgetsFix {
        private SingleCharacterStartsWithFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("single.character.startswith.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression insertedElement;
            PsiMethod[] isEmptyMethod;
            PsiElement element = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)element.getParent();
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)methodExpression.getParent();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiExpressionList argumentList = methodCall.getArgumentList();
            PsiExpression[] expressions2 = argumentList.getExpressions();
            PsiExpression expression2 = expressions2[0];
            String expressionText = expression2.getText();
            String character = expressionText.substring(1, expressionText.length() - 1);
            if (character.equals("'")) {
                character = "\\'";
            }
            String qualifierText = qualifier.getText();
            StringBuilder newExpression = new StringBuilder();
            PsiClass stringClass = ClassUtils.findClass("java.lang.String", qualifier);
            PsiMethod[] psiMethodArray = isEmptyMethod = stringClass == null ? PsiMethod.EMPTY_ARRAY : stringClass.findMethodsByName("isEmpty", false);
            if (isEmptyMethod.length > 0) {
                newExpression.append("!").append(qualifierText).append(".isEmpty() && ");
            } else {
                newExpression.append(qualifierText).append(".length() > 0 && ");
            }
            String referenceName = methodExpression.getReferenceName();
            newExpression.append(qualifierText).append(".charAt(");
            if ("startsWith".equals(referenceName)) {
                newExpression.append("0) == '");
            } else {
                newExpression.append(qualifierText).append(".length() - 1) == '");
            }
            newExpression.append(character).append('\'');
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.markUnchanged(qualifier);
            PsiExpression newCall = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newExpression.toString(), (PsiElement)methodCall);
            if (newCall instanceof PsiPolyadicExpression && (insertedElement = ExpressionUtils.replacePolyadicWithParent((PsiExpression)methodCall, newCall, commentTracker)) != null) {
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)insertedElement);
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCall, newExpression.toString(), commentTracker);
        }
    }
}

