/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.fixes.AddArgumentFix;
import com.siyeh.ig.internationalization.NonNlsUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class StringToUpperWithoutLocaleInspection
extends BaseInspection {
    private static final CallMatcher MATCHER = CallMatcher.instanceCall("java.lang.String", "toUpperCase", "toLowerCase").parameterCount(0);

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "StringToUpperCaseOrToLowerCaseWithoutLocale";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.touppercase.tolowercase.without.locale.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)infos[0];
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>(2);
        PsiModifierListOwner annotatableQualifier = NonNlsUtils.getAnnotatableQualifier(methodExpression);
        fixes.add(new AddArgumentFix("java.util.Locale.ENGLISH", "Locale.ENGLISH"));
        if (annotatableQualifier != null) {
            fixes.add(new DelegatingFix((LocalQuickFix)new AddAnnotationPsiFix("org.jetbrains.annotations.NonNls", annotatableQualifier, PsiNameValuePair.EMPTY_ARRAY, new String[0])));
        }
        return fixes.toArray(InspectionGadgetsFix.EMPTY_ARRAY);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringToUpperWithoutLocaleVisitor();
    }

    private static class StringToUpperWithoutLocaleVisitor
    extends BaseInspectionVisitor {
        private StringToUpperWithoutLocaleVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (!MATCHER.test(expression2)) {
                return;
            }
            PsiExpression qualifier = expression2.getMethodExpression().getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotatedUse((PsiExpression)expression2) || NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            this.registerMethodCallError(expression2, expression2.getMethodExpression());
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (!MATCHER.methodReferenceMatches(expression2)) {
                return;
            }
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (NonNlsUtils.isNonNlsAnnotatedUse(qualifier) || NonNlsUtils.isNonNlsAnnotated(qualifier)) {
                return;
            }
            PsiElement nameElement = Objects.requireNonNull(expression2.getReferenceNameElement());
            this.registerError(nameElement, expression2);
        }
    }
}

