/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.internationalization.NonNlsUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharacterComparisonInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CharacterComparison";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("character.comparison.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CharacterComparisonVisitor();
    }

    private static class CharacterComparisonVisitor
    extends BaseInspectionVisitor {
        private CharacterComparisonVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (!ComparisonUtils.isComparison((PsiExpression)expression2) || ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            if (!CharacterComparisonVisitor.isCharacter(lhs) || !CharacterComparisonVisitor.isCharacter(rhs)) {
                return;
            }
            if (NonNlsUtils.isNonNlsAnnotated(lhs) || NonNlsUtils.isNonNlsAnnotated(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static boolean isCharacter(@Nullable PsiExpression expression2) {
            return ExpressionUtils.hasType(expression2, "char") || ExpressionUtils.hasType(expression2, "java.lang.Character");
        }
    }
}

