/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NonProtectedConstructorInAbstractClassInspection
extends BaseInspection {
    public boolean m_ignoreNonPublicClasses = false;

    @NotNull
    public String getID() {
        return "ConstructorNotProtectedInAbstractClass";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("non.protected.constructor.in.abstract.class.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreNonPublicClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonProtectedConstructorInAbstractClassVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("protected");
    }

    private class NonProtectedConstructorInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private NonProtectedConstructorInAbstractClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!method.isConstructor()) {
                return;
            }
            if (method.hasModifierProperty("protected") || method.hasModifierProperty("private") || method.hasModifierProperty("packageLocal")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (NonProtectedConstructorInAbstractClassInspection.this.m_ignoreNonPublicClasses && !containingClass.hasModifierProperty("public")) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

