/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendsUtilityClassInspection
extends BaseInspection {
    public boolean ignoreUtilityClasses = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        String superClassName = superClass.getName();
        return InspectionGadgetsBundle.message("class.extends.utility.class.problem.descriptor", superClassName);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("class.extends.utility.class.ignore.utility.class.option", new Object[0]), (InspectionProfileEntry)this, "ignoreUtilityClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassExtendsUtilityClassVisitor();
    }

    private class ClassExtendsUtilityClassVisitor
    extends BaseInspectionVisitor {
        private ClassExtendsUtilityClassVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (superClass.hasModifierProperty("abstract")) {
                return;
            }
            if (!UtilityClassUtil.isUtilityClass(superClass)) {
                return;
            }
            if (ExtendsUtilityClassInspection.this.ignoreUtilityClasses && UtilityClassUtil.isUtilityClass(aClass, false)) {
                return;
            }
            this.registerClassError(aClass, superClass);
        }
    }
}

