/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import java.util.HashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class NormalizeDeclarationFix
extends InspectionGadgetsFix {
    private final boolean myCStyleDeclaration;

    public NormalizeDeclarationFix(boolean cStyleDeclaration) {
        this.myCStyleDeclaration = cStyleDeclaration;
    }

    @NotNull
    public String getFamilyName() {
        return this.myCStyleDeclaration ? InspectionGadgetsBundle.message("c.style.array.declaration.replace.quickfix", new Object[0]) : InspectionGadgetsBundle.message("normalize.declaration.quickfix", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiVariable || element instanceof PsiMethod || element instanceof PsiDeclarationStatement)) {
            element = element.getParent();
        }
        if (element instanceof PsiParameter || element instanceof PsiRecordComponent) {
            JavaSharedImplUtil.normalizeBrackets((PsiVariable)element);
            return;
        }
        if (element instanceof PsiLocalVariable && !((element = element.getParent()) instanceof PsiDeclarationStatement)) {
            return;
        }
        if (element instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)element;
            PsiElement grandParent = element.getParent();
            if (grandParent instanceof PsiForStatement) {
                NormalizeDeclarationFix.splitMultipleDeclarationInForStatementInitialization((PsiForStatement)grandParent);
            } else {
                PsiElement[] elements = declarationStatement.getDeclaredElements();
                PsiVariable variable = (PsiVariable)elements[0];
                variable.normalizeDeclaration();
                for (int i = 1; i < elements.length; ++i) {
                    declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)declarationStatement, PsiDeclarationStatement.class);
                    assert (declarationStatement != null);
                    JavaSharedImplUtil.normalizeBrackets((PsiVariable)declarationStatement.getDeclaredElements()[0]);
                }
            }
        } else if (element instanceof PsiField) {
            PsiField field;
            PsiField nextField = field = DeclarationSearchUtils.findFirstFieldInDeclaration((PsiField)element);
            int count = 0;
            while (nextField != null) {
                ++count;
                nextField = DeclarationSearchUtils.findNextFieldInDeclaration(nextField);
            }
            field.normalizeDeclaration();
            for (int i = 1; i < count; ++i) {
                field = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, PsiField.class);
                assert (field != null);
                JavaSharedImplUtil.normalizeBrackets((PsiVariable)field);
            }
        } else if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiParameterList child = method.getParameterList();
            while (!(child instanceof PsiCodeBlock)) {
                IElementType tokenType;
                PsiParameterList elementToDelete = child;
                child = child.getNextSibling();
                if (!(elementToDelete instanceof PsiJavaToken) || !JavaTokenType.LBRACKET.equals(tokenType = ((PsiJavaToken)elementToDelete).getTokenType()) && !JavaTokenType.RBRACKET.equals(tokenType)) continue;
                elementToDelete.delete();
            }
            PsiTypeElement typeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElement(returnType);
            returnTypeElement.replace((PsiElement)typeElement);
        }
    }

    private static void splitMultipleDeclarationInForStatementInitialization(PsiForStatement forStatement) {
        int max;
        int min;
        PsiStatement initialization;
        if (!(forStatement.getParent() instanceof PsiCodeBlock)) {
            forStatement = BlockUtils.expandSingleStatementToBlockStatement(forStatement);
        }
        if (!((initialization = forStatement.getInitialization()) instanceof PsiDeclarationStatement)) {
            return;
        }
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)initialization;
        List variables = StreamEx.of((Object[])declarationStatement.getDeclaredElements()).select(PsiLocalVariable.class).toList();
        boolean dependentVariables = NormalizeDeclarationFix.containsDependentVariables(variables);
        if (dependentVariables) {
            min = 0;
            max = variables.size() - 1;
        } else {
            min = 1;
            max = variables.size();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)forStatement.getProject());
        CommentTracker ct = new CommentTracker();
        for (int i = min; i < max; ++i) {
            PsiVariable variable = (PsiVariable)variables.get(i);
            String name2 = variable.getName();
            assert (name2 != null);
            PsiDeclarationStatement newStatement = factory.createVariableDeclarationStatement(name2, variable.getType(), ct.markUnchanged(variable.getInitializer()), (PsiElement)declarationStatement);
            forStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)forStatement);
        }
        PsiVariable remainingVariable = (PsiVariable)variables.get(dependentVariables ? variables.size() - 1 : 0);
        String name3 = remainingVariable.getName();
        assert (name3 != null);
        PsiDeclarationStatement replacementStatement = factory.createVariableDeclarationStatement(name3, remainingVariable.getType(), ct.markUnchanged(remainingVariable.getInitializer()), (PsiElement)declarationStatement);
        ct.replaceAndRestoreComments((PsiElement)declarationStatement, (PsiElement)replacementStatement);
    }

    private static boolean containsDependentVariables(List<PsiLocalVariable> variables) {
        if (variables.isEmpty()) {
            return false;
        }
        HashSet visited = ContainerUtil.newHashSet((Object[])new PsiLocalVariable[]{variables.get(0)});
        for (int i = 1; i < variables.size(); ++i) {
            PsiLocalVariable variable = variables.get(i);
            if (!PsiTreeUtil.processElements((PsiElement)variable.getInitializer(), element -> !visited.contains(NormalizeDeclarationFix.tryResolveLocalVariable(element)))) {
                return true;
            }
            visited.add(variable);
        }
        return false;
    }

    private static PsiLocalVariable tryResolveLocalVariable(PsiElement element) {
        PsiReferenceExpression referenceExpression;
        if (element instanceof PsiReferenceExpression && (referenceExpression = (PsiReferenceExpression)element).getQualifierExpression() == null) {
            return (PsiLocalVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiLocalVariable.class);
        }
        return null;
    }
}

