/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class MakeMethodFinalFix
extends InspectionGadgetsFix {
    private final String myMethodName;

    public MakeMethodFinalFix(String methodName) {
        this.myMethodName = methodName;
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("make.method.final.fix.name", this.myMethodName);
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("make.method.final.fix.family.name", new Object[0]);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement().getParent();
        if (element instanceof PsiMethod) {
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
                return;
            }
            PsiMethod method = (PsiMethod)element;
            PsiModifierList modifierList = method.getModifierList();
            WriteAction.run(() -> modifierList.setModifierProperty("final", true));
            return;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
            PsiMethod method = methodCall.resolveMethod();
            if (method == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
                return;
            }
            WriteAction.run(() -> method.getModifierList().setModifierProperty("final", true));
            if (this.isOnTheFly() && method.getContainingFile() != parent.getContainingFile()) {
                method.navigate(true);
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

