/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class MakeInitializerExplicitFix
extends InspectionGadgetsFix {
    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("make.initialization.explicit.quickfix", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement fieldName = descriptor.getPsiElement();
        PsiElement parent = fieldName.getParent();
        if (!(parent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        if (field.getInitializer() != null) {
            return;
        }
        PsiType type2 = field.getType();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression initializer = factory.createExpressionFromText(TypeUtils.getDefaultValue(type2), (PsiElement)field);
        field.setInitializer(initializer);
    }
}

