/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeFieldStaticFinalFix
extends InspectionGadgetsFix {
    private final String fieldName;

    private MakeFieldStaticFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @NotNull
    public static InspectionGadgetsFix buildFixUnconditional(@NotNull PsiField field) {
        return new MakeFieldStaticFinalFix(field.getName());
    }

    @Nullable
    public static InspectionGadgetsFix buildFix(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return null;
        }
        if (!FinalUtils.canBeFinal((PsiVariable)field)) {
            return null;
        }
        return new MakeFieldStaticFinalFix(field.getName());
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("make.static.final.quickfix", this.fieldName);
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("make.field.static.final.fix.family.name", new Object[0]);
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("final", true);
        modifierList.setModifierProperty("static", true);
    }
}

