/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityToSafeEqualsFix
extends InspectionGadgetsFix {
    private final boolean myNegated;

    private EqualityToSafeEqualsFix(boolean negated) {
        this.myNegated = negated;
    }

    @Nullable
    public static EqualityToSafeEqualsFix buildFix(PsiBinaryExpression expression2) {
        if (NullabilityUtil.getExpressionNullability(expression2.getLOperand()) == Nullability.NOT_NULL) {
            return null;
        }
        return new EqualityToSafeEqualsFix(JavaTokenType.NE.equals(expression2.getOperationTokenType()));
    }

    @Nls
    @NotNull
    public String getName() {
        return this.myNegated ? InspectionGadgetsBundle.message("inequality.to.safe.not.equals.quickfix", new Object[0]) : InspectionGadgetsBundle.message("equality.to.safe.equals.quickfix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("equality.to.safe.equals.quickfix", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement comparisonToken = descriptor.getPsiElement();
        PsiElement parent = comparisonToken.getParent();
        if (!(parent instanceof PsiBinaryExpression)) {
            return;
        }
        PsiBinaryExpression expression2 = (PsiBinaryExpression)parent;
        PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLOperand());
        PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getROperand());
        if (lhs == null || rhs == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        String lhsText = tracker.text((PsiElement)lhs);
        String rhsText = tracker.text((PsiElement)rhs);
        StringBuilder newExpression = new StringBuilder();
        if (PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression2) && ClassUtils.findClass("java.util.Objects", (PsiElement)expression2) != null) {
            if (JavaTokenType.NE.equals(expression2.getOperationTokenType())) {
                newExpression.append('!');
            }
            newExpression.append("java.util.Objects.equals(").append(lhsText).append(',').append(rhsText).append(')');
        } else {
            newExpression.append(lhsText).append("==null?").append(rhsText).append(expression2.getOperationSign().getText()).append(" null:");
            if (JavaTokenType.NE.equals(expression2.getOperationTokenType())) {
                newExpression.append('!');
            }
            if (ParenthesesUtils.getPrecedence(lhs) > 1) {
                newExpression.append('(').append(lhsText).append(')');
            } else {
                newExpression.append(lhsText);
            }
            newExpression.append(".equals(").append(rhsText).append(')');
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression2, newExpression.toString(), tracker);
    }
}

