/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.VisibilityUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangeModifierFix
extends InspectionGadgetsFix {
    @PsiModifier.ModifierConstant
    private final String modifierText;

    public ChangeModifierFix(@NonNls @PsiModifier.ModifierConstant String modifierText) {
        this.modifierText = modifierText;
    }

    @NotNull
    public String getName() {
        return InspectionGadgetsBundle.message("change.modifier.quickfix", VisibilityUtil.toPresentableText((String)this.modifierText));
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("change.modifier.fix.family.name", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
        if (modifierListOwner == null) {
            return;
        }
        PsiModifierList modifiers = modifierListOwner.getModifierList();
        if (modifiers == null) {
            return;
        }
        modifiers.setModifierProperty(this.modifierText, true);
    }
}

