/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceWithCloneFix
extends InspectionGadgetsFix {
    private final String myName;

    ReplaceWithCloneFix(String name2) {
        this.myName = name2;
    }

    @NotNull
    public String getName() {
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myName + ".clone()"});
    }

    @NotNull
    public String getFamilyName() {
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"clone()"});
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
        if (referenceExpression.getType() instanceof PsiArrayType) {
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, referenceExpression.getText() + ".clone()");
        } else {
            String type2 = TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Date", "java.util.Calendar");
            if (type2 == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, '(' + type2 + ')' + referenceExpression.getText() + ".clone()");
        }
    }
}

