/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MoveClassFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtectedInnerClassInspection
extends BaseInspection {
    public boolean ignoreEnums = false;
    public boolean ignoreInterfaces = false;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MoveClassFix();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("protected.inner.class.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("protected.inner.class.ignore.enum.option", new Object[0]), "ignoreEnums");
        panel2.addCheckbox(InspectionGadgetsBundle.message("protected.inner.class.ignore.interface.option", new Object[0]), "ignoreInterfaces");
        return panel2;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedInnerClassVisitor();
    }

    private class ProtectedInnerClassVisitor
    extends BaseInspectionVisitor {
        private ProtectedInnerClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!aClass.hasModifierProperty("protected")) {
                return;
            }
            if (!ClassUtils.isInnerClass(aClass)) {
                return;
            }
            if (ProtectedInnerClassInspection.this.ignoreEnums && aClass.isEnum()) {
                return;
            }
            if (ProtectedInnerClassInspection.this.ignoreInterfaces && aClass.isInterface()) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

