/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class NegatedEqualityExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("negated.equality.expression.problem.descriptor", infos[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new NegatedEqualityExpressionFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NegatedEqualsVisitor();
    }

    private static class NegatedEqualsVisitor
    extends BaseInspectionVisitor {
        private NegatedEqualsVisitor() {
        }

        public void visitPrefixExpression(PsiPrefixExpression expression2) {
            super.visitPrefixExpression(expression2);
            if (!JavaTokenType.EXCL.equals(expression2.getOperationTokenType())) {
                return;
            }
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
            if (!(operand2 instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                this.registerError((PsiElement)expression2.getOperationSign(), "==");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                this.registerError((PsiElement)expression2.getOperationSign(), "!=");
            }
        }
    }

    private static class NegatedEqualityExpressionFix
    extends InspectionGadgetsFix {
        private NegatedEqualityExpressionFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("negated.equality.expression.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiPrefixExpression)) {
                return;
            }
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
            if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                return;
            }
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)prefixExpression.getOperand());
            if (!(operand2 instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)operand2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder text2 = new StringBuilder(commentTracker.text((PsiElement)binaryExpression.getLOperand()));
            if (JavaTokenType.EQEQ.equals(tokenType)) {
                text2.append("!=");
            } else if (JavaTokenType.NE.equals(tokenType)) {
                text2.append("==");
            } else {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs != null) {
                text2.append(commentTracker.text((PsiElement)rhs));
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, text2.toString(), commentTracker);
        }
    }
}

