/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoopStatementsThatDontLoopInspection
extends BaseInspection {
    public boolean ignoreForeach = true;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "LoopStatementThatDoesntLoop";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("loop.statements.that.dont.loop.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.enhanced.for.loop.statements", new Object[0]), (InspectionProfileEntry)this, "ignoreForeach");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoopStatementsThatDontLoopVisitor();
    }

    private class LoopStatementsThatDontLoopVisitor
    extends BaseInspectionVisitor {
        private LoopStatementsThatDontLoopVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            super.visitForStatement(statement);
            this.checkLoop((PsiLoopStatement)statement);
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            if (LoopStatementsThatDontLoopInspection.this.ignoreForeach) {
                return;
            }
            this.checkLoop((PsiLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            this.checkLoop((PsiLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            this.checkLoop((PsiLoopStatement)statement);
        }

        private void checkLoop(@NotNull PsiLoopStatement statement) {
            PsiStatement body2 = statement.getBody();
            if (body2 == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(body2)) {
                return;
            }
            if (ControlFlowUtils.statementIsContinueTarget((PsiStatement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }
}

