/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfiniteLoopStatementInspection
extends BaseInspection {
    boolean myIgnoreInThreadTopLevel = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"inspection.infinite.loop.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "myIgnoreInThreadTopLevel");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("infinite.loop.statement.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InfiniteLoopStatementsVisitor(this.myIgnoreInThreadTopLevel);
    }

    private static class InfiniteLoopStatementsVisitor
    extends BaseInspectionVisitor {
        final boolean myIgnoreInThreadTopLevel;

        InfiniteLoopStatementsVisitor(boolean ignoreInThreadTopLevel) {
            this.myIgnoreInThreadTopLevel = ignoreInThreadTopLevel;
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            super.visitForStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            super.visitWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            super.visitDoWhileStatement(statement);
            this.checkStatement((PsiStatement)statement);
        }

        private void checkStatement(PsiStatement statement) {
            PsiExpression argument;
            PsiClass maybeAnonymous;
            PsiClass aClass;
            boolean allUsagesAreInThreadStart;
            PsiMethod method;
            PsiElement parent;
            if (ControlFlowUtils.statementMayCompleteNormally(statement)) {
                return;
            }
            if (ControlFlowUtils.containsReturn((PsiElement)statement)) {
                return;
            }
            if (ControlFlowUtils.containsSystemExit((PsiElement)statement)) {
                return;
            }
            if (this.myIgnoreInThreadTopLevel && ((parent = PsiTreeUtil.findFirstParent((PsiElement)statement, element -> element instanceof PsiMethod || element instanceof PsiLambdaExpression || element instanceof PsiAnonymousClass)) instanceof PsiMethod ? ((method = (PsiMethod)parent).hasModifier(JvmModifier.PRIVATE) ? (allUsagesAreInThreadStart = ((StreamEx)StreamEx.ofTree((Object)(aClass = method.getContainingClass()), element -> StreamEx.of((Object[])element.getChildren())).filter(element -> {
                if (element instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                    return call.getMethodExpression().isReferenceTo((PsiElement)method);
                }
                if (element instanceof PsiMethodReferenceExpression) {
                    PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)element;
                    return methodReference.isReferenceTo((PsiElement)method);
                }
                return false;
            })).select(PsiExpression.class).allMatch(inArgument -> {
                if (inArgument instanceof PsiMethodCallExpression) {
                    return InfiniteLoopStatementsVisitor.isArgumentInThreadConstructor(inArgument);
                }
                if (inArgument instanceof PsiMethodReferenceExpression) {
                    return InfiniteLoopStatementsVisitor.isInThreadConstructor(inArgument);
                }
                return false;
            })) : (maybeAnonymous = (PsiClass)ObjectUtils.tryCast((Object)method.getContainingClass(), PsiAnonymousClass.class)) != null && "run".equals(method.getName()) && method.getParameterList().isEmpty() && InfiniteLoopStatementsVisitor.isInThreadConstructor(argument = (PsiExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)maybeAnonymous.getParent()), PsiExpression.class))) : parent instanceof PsiLambdaExpression && InfiniteLoopStatementsVisitor.isInThreadConstructor((PsiExpression)parent))) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static boolean isArgumentInThreadConstructor(@Nullable PsiExpression inArgument) {
            PsiElement skipped = PsiUtil.skipParenthesizedExprUp((PsiElement)inArgument);
            if (skipped == null) {
                return false;
            }
            PsiElement argParent = skipped.getParent();
            PsiExpression argument = null;
            if (argParent instanceof PsiLambdaExpression) {
                argument = (PsiExpression)argParent;
            } else if (argParent instanceof PsiAnonymousClass) {
                argument = (PsiExpression)ObjectUtils.tryCast((Object)argParent, PsiNewExpression.class);
            }
            return InfiniteLoopStatementsVisitor.isInThreadConstructor(argument);
        }

        private static boolean isInThreadConstructor(PsiExpression argument) {
            PsiClass aClass;
            PsiMethod constructor;
            PsiElement argumentParent;
            PsiConstructorCall constructorCall;
            return argument != null && (constructorCall = (PsiConstructorCall)ObjectUtils.tryCast((Object)(argumentParent = PsiUtil.skipParenthesizedExprUp((PsiElement)PsiUtil.skipParenthesizedExprUp((PsiElement)argument).getParent())).getParent(), PsiConstructorCall.class)) != null && (constructor = constructorCall.resolveConstructor()) != null && (aClass = constructor.getContainingClass()) != null && "java.lang.Thread".equals(aClass.getQualifiedName());
        }
    }
}

