/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class ForLoopReplaceableByWhileInspection
extends BaseInspection {
    public boolean m_ignoreLoopsWithoutConditions = true;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ForLoopReplaceableByWhile";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), "m_ignoreLoopsWithoutConditions");
        return panel2;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceForByWhileFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            ProblemHighlightType highlightType;
            super.visitForStatement(statement);
            if (PsiUtilCore.hasErrorElementChild((PsiElement)statement)) {
                return;
            }
            if (this.highlightLoop(statement)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            }
            this.registerError(statement.getFirstChild(), highlightType, new Object[0]);
        }

        private boolean highlightLoop(@NotNull PsiForStatement statement) {
            PsiStatement initialization = statement.getInitialization();
            if (initialization != null && !(initialization instanceof PsiEmptyStatement)) {
                return false;
            }
            PsiStatement update2 = statement.getUpdate();
            if (update2 != null && !(update2 instanceof PsiEmptyStatement)) {
                return false;
            }
            if (ForLoopReplaceableByWhileInspection.this.m_ignoreLoopsWithoutConditions) {
                PsiExpression condition2 = statement.getCondition();
                return condition2 != null && !BoolUtils.isTrue(condition2);
            }
            return true;
        }
    }

    private static class ReplaceForByWhileFix
    extends InspectionGadgetsFix {
        private ReplaceForByWhileFix() {
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"while"});
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiCodeBlock loopBody;
            PsiBlockStatement blockStatement;
            PsiElement element = descriptor.getPsiElement();
            PsiForStatement forStatement = (PsiForStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiForStatement.class);
            if (forStatement == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiStatement initialization = forStatement.getInitialization();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
            PsiExpression forCondition = forStatement.getCondition();
            PsiExpression whileCondition = whileStatement.getCondition();
            if (forCondition != null) {
                assert (whileCondition != null);
                commentTracker.replace((PsiElement)whileCondition, (PsiElement)forCondition);
            }
            if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
                return;
            }
            PsiStatement forStatementBody = forStatement.getBody();
            if (forStatementBody instanceof PsiBlockStatement) {
                PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace((PsiElement)commentTracker.markUnchanged(forStatementBody));
                loopBody = newWhileBody.getCodeBlock();
            } else {
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                if (forStatementBody != null && !(forStatementBody instanceof PsiEmptyStatement)) {
                    codeBlock.add((PsiElement)commentTracker.markUnchanged(forStatementBody));
                }
                loopBody = codeBlock;
            }
            PsiStatement update2 = forStatement.getUpdate();
            if (update2 != null) {
                PsiStatement[] updateStatements;
                if (update2 instanceof PsiExpressionListStatement) {
                    PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update2;
                    PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                    PsiExpression[] expressions2 = expressionList.getExpressions();
                    updateStatements = new PsiStatement[expressions2.length];
                    for (int i = 0; i < expressions2.length; ++i) {
                        updateStatements[i] = factory.createStatementFromText(commentTracker.text((PsiElement)expressions2[i]) + ';', element);
                    }
                } else {
                    PsiStatement updateStatement = factory.createStatementFromText(commentTracker.markUnchanged(update2).getText() + ';', element);
                    updateStatements = new PsiStatement[]{updateStatement};
                }
                Collection continueStatements = PsiTreeUtil.findChildrenOfType((PsiElement)loopBody, PsiContinueStatement.class);
                for (PsiContinueStatement continueStatement : continueStatements) {
                    BlockUtils.addBefore((PsiStatement)continueStatement, updateStatements);
                }
                for (PsiStatement updateStatement : updateStatements) {
                    loopBody.addBefore((PsiElement)updateStatement, loopBody.getLastChild());
                }
            }
            if (initialization == null || initialization instanceof PsiEmptyStatement) {
                commentTracker.replaceAndRestoreComments((PsiElement)forStatement, (PsiElement)whileStatement);
            } else {
                JavaCodeStyleManager manager;
                initialization = (PsiStatement)commentTracker.markUnchanged(initialization).copy();
                PsiStatement newStatement = (PsiStatement)commentTracker.replaceAndRestoreComments((PsiElement)forStatement, (PsiElement)whileStatement);
                if (initialization instanceof PsiDeclarationStatement && ReplaceForByWhileFix.hasConflictingName((PsiDeclarationStatement)initialization, newStatement, manager = JavaCodeStyleManager.getInstance((Project)newStatement.getProject()))) {
                    PsiBlockStatement emptyBlockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)newStatement);
                    emptyBlockStatement.getCodeBlock().add((PsiElement)newStatement);
                    newStatement = ((PsiBlockStatement)newStatement.replace((PsiElement)emptyBlockStatement)).getCodeBlock().getStatements()[0];
                }
                BlockUtils.addBefore(newStatement, initialization);
            }
        }

        private static boolean hasConflictingName(PsiDeclarationStatement initialization, PsiStatement newStatement, JavaCodeStyleManager manager) {
            return ((StreamEx)StreamEx.of((Object[])initialization.getDeclaredElements()).select(PsiNamedElement.class).map(namedElement -> namedElement.getName()).filter(Objects::nonNull)).anyMatch(name2 -> !name2.equals(manager.suggestUniqueVariableName(name2, (PsiElement)newStatement, true)));
        }
    }
}

