/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ConstantConditionalExpressionInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)infos[0];
        return InspectionGadgetsBundle.message("constant.conditional.expression.problem.descriptor", ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2).getText());
    }

    @NotNull
    static PsiExpression calculateReplacementExpression(@NotNull PsiConditionalExpression exp) {
        PsiExpression thenExpression2 = exp.getThenExpression();
        PsiExpression elseExpression2 = exp.getElseExpression();
        PsiExpression condition2 = exp.getCondition();
        assert (thenExpression2 != null);
        assert (elseExpression2 != null);
        return BoolUtils.isTrue(condition2) ? thenExpression2 : elseExpression2;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConstantConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression condition2 = expression2.getCondition();
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (elseExpression2 == null) {
                return;
            }
            if (BoolUtils.isFalse(condition2) || BoolUtils.isTrue(condition2)) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }
    }

    private static class ConstantConditionalFix
    extends InspectionGadgetsFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor.getPsiElement();
            CommentTracker ct = new CommentTracker();
            PsiExpression replacement = ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2);
            PsiType type2 = replacement.getType();
            PsiType expressionType = expression2.getType();
            if (type2 != null && expressionType != null && !type2.equals(expressionType) && PsiTypesUtil.isDenotableType((PsiType)expressionType, (PsiElement)expression2)) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)ct.replaceAndRestoreComments((PsiElement)expression2, "(" + expressionType.getCanonicalText() + ")" + ct.text(replacement, 4));
                if (RedundantCastUtil.isCastRedundant(castExpression)) {
                    RemoveRedundantCastUtil.removeCast(castExpression);
                }
            } else {
                ct.replaceAndRestoreComments((PsiElement)expression2, (PsiElement)replacement);
            }
        }
    }
}

