/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeClassFinalFix;
import com.siyeh.ig.psiutils.UtilityClassUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonFinalUtilityClassInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new MakeClassFinalFix((PsiClass)infos[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.final.utility.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonFinalUtilityClassVisitor();
    }

    private static class NonFinalUtilityClassVisitor
    extends BaseInspectionVisitor {
        private NonFinalUtilityClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!UtilityClassUtil.isUtilityClass(aClass)) {
                return;
            }
            if (aClass.hasModifierProperty("final") || aClass.hasModifierProperty("abstract")) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

