/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodInheritanceUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodReturnAlwaysConstantInspection
extends BaseGlobalInspection {
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        PsiElement psi;
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (refMethod.hasSuperMethods()) {
            return null;
        }
        PsiElement element = refMethod.getPsiElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        if (((PsiMethod)element).getBody() == null && refMethod.getDerivedMethods().isEmpty()) {
            return null;
        }
        Set<RefMethod> allScopeInheritors = MethodInheritanceUtils.calculateSiblingMethods(refMethod);
        for (RefMethod siblingMethod : allScopeInheritors) {
            PsiMethod siblingPsiMethod;
            psi = siblingMethod.getPsiElement();
            if (!(psi instanceof PsiMethod) || (siblingPsiMethod = (PsiMethod)psi).getBody() == null || MethodReturnAlwaysConstantInspection.alwaysReturnsConstant(siblingPsiMethod)) continue;
            return null;
        }
        for (RefMethod siblingRefMethod : allScopeInheritors) {
            PsiMethod siblingMethod;
            PsiIdentifier identifier;
            psi = siblingRefMethod.getPsiElement();
            if (!(psi instanceof PsiMethod) || (identifier = (siblingMethod = (PsiMethod)psi).getNameIdentifier()) == null) continue;
            processor2.addProblemElement((RefEntity)siblingRefMethod, new CommonProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)identifier, InspectionGadgetsBundle.message("method.return.always.constant.problem.descriptor", new Object[0]), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)});
        }
        return null;
    }

    private static boolean alwaysReturnsConstant(PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body2);
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression value2 = returnStatement.getReturnValue();
        return value2 != null && PsiUtil.isConstantExpression((PsiExpression)value2);
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor2.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(@NotNull RefMethod refMethod) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                                processor2.ignoreElement((RefEntity)refMethod);
                                return false;
                            });
                        }
                    });
                }
            }
        });
        return false;
    }
}

