/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ListenerMayUseAdapterInspection
extends BaseInspection {
    public boolean checkForEmptyMethods = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className2 = aClass.getName();
        String adapterName = (String)infos[1];
        return InspectionGadgetsBundle.message("listener.may.use.adapter.problem.descriptor", className2, adapterName);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("listener.may.use.adapter.emtpy.methods.option", new Object[0]), (InspectionProfileEntry)this, "checkForEmptyMethods");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String adapterName = (String)infos[1];
        return new ListenerMayUseAdapterFix(adapterName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ListenerMayUseAdapterVisitor();
    }

    private class ListenerMayUseAdapterVisitor
    extends BaseInspectionVisitor {
        private ListenerMayUseAdapterVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] implementsReferences;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] extendsReferences = extendsList.getReferenceElements();
            if (extendsReferences.length > 0) {
                return;
            }
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement implementsReference : implementsReferences = implementsList.getReferenceElements()) {
                this.checkReference(aClass, implementsReference);
            }
        }

        private void checkReference(@NotNull PsiClass aClass, @NotNull PsiJavaCodeReferenceElement implementsReference) {
            PsiElement target = implementsReference.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass implementsClass = (PsiClass)target;
            String className2 = implementsClass.getQualifiedName();
            if (className2 == null || !className2.endsWith("Listener")) {
                return;
            }
            PsiMethod[] interfaceMethods = implementsClass.getMethods();
            if (interfaceMethods.length < 2) {
                return;
            }
            boolean allDefault = true;
            for (PsiMethod interfaceMethod : interfaceMethods) {
                if (interfaceMethod.hasModifierProperty("default")) continue;
                allDefault = false;
                break;
            }
            if (allDefault) {
                return;
            }
            String adapterName = className2.substring(0, className2.length() - 8) + "Adapter";
            GlobalSearchScope scope = implementsClass.getResolveScope();
            PsiClass adapterClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(adapterName, scope);
            if (adapterClass == null || adapterClass.equals(aClass) || !adapterClass.hasModifierProperty("abstract") || adapterClass.isDeprecated()) {
                return;
            }
            PsiReferenceList implementsList = adapterClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            PsiJavaCodeReferenceElement[] referenceElements = implementsList.getReferenceElements();
            boolean adapterImplementsListener = false;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
                PsiElement implementsTarget = referenceElement.resolve();
                if (!implementsClass.equals(implementsTarget)) continue;
                adapterImplementsListener = true;
            }
            if (!adapterImplementsListener) {
                return;
            }
            if (ListenerMayUseAdapterInspection.this.checkForEmptyMethods) {
                PsiMethod[] methods;
                boolean emptyMethodFound = false;
                for (PsiMethod method : methods = aClass.getMethods()) {
                    PsiMethod[] superMethods;
                    PsiCodeBlock body2 = method.getBody();
                    if (!ControlFlowUtils.isEmptyCodeBlock(body2) || (superMethods = method.findSuperMethods(implementsClass)).length == 0) continue;
                    emptyMethodFound = true;
                    break;
                }
                if (!emptyMethodFound) {
                    return;
                }
            }
            this.registerError((PsiElement)implementsReference, aClass, adapterName);
        }
    }

    private static class ListenerMayUseAdapterFix
    extends InspectionGadgetsFix {
        private final String adapterName;

        ListenerMayUseAdapterFix(@NotNull String adapterName) {
            this.adapterName = adapterName;
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"extends " + this.adapterName});
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("listener.may.use.adapter.fix.family.name", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)descriptor.getPsiElement();
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (aClass == null) {
                return;
            }
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                PsiElement target = element.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                PsiClass interfaceClass = (PsiClass)target;
                for (PsiMethod method : methods) {
                    PsiMethod[] superMethods;
                    if (!ControlFlowUtils.isEmptyCodeBlock(method.getBody()) || (superMethods = method.findSuperMethods(interfaceClass)).length <= 0) continue;
                    method.delete();
                }
            }
            element.delete();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass adapterClass = psiFacade.findClass(this.adapterName, aClass.getResolveScope());
            if (adapterClass == null) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = psiFacade.getElementFactory().createClassReferenceElement(adapterClass);
            extendsList.add((PsiElement)referenceElement);
        }
    }
}

