/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SuspiciousSystemArraycopyInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return (String)infos[0];
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousSystemArraycopyVisitor();
    }

    private static class SuspiciousSystemArraycopyVisitor
    extends BaseInspectionVisitor {
        private SuspiciousSystemArraycopyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiType destType;
            super.visitMethodCallExpression(expression2);
            PsiClassType objectType = TypeUtils.getObjectType((PsiElement)expression2);
            if (!MethodCallUtils.isCallToMethod(expression2, "java.lang.System", (PsiType)PsiType.VOID, "arraycopy", new PsiType[]{objectType, PsiType.INT, objectType, PsiType.INT, PsiType.INT})) {
                return;
            }
            PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
            if (arguments.length != 5) {
                return;
            }
            PsiExpression srcPos = arguments[1];
            PsiExpression destPos = arguments[3];
            PsiExpression length = arguments[4];
            PsiExpression src = arguments[0];
            PsiExpression dest = arguments[2];
            this.checkRanges(src, srcPos, dest, destPos, length, expression2);
            PsiType srcType = src.getType();
            if (srcType == null) {
                return;
            }
            boolean notArrayReported = false;
            if (!(srcType instanceof PsiArrayType)) {
                this.registerError((PsiElement)src, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor4", new Object[0]));
                notArrayReported = true;
            }
            if ((destType = dest.getType()) == null) {
                return;
            }
            if (!(destType instanceof PsiArrayType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor5", new Object[0]));
                notArrayReported = true;
            }
            if (notArrayReported) {
                return;
            }
            PsiArrayType srcArrayType = (PsiArrayType)srcType;
            PsiArrayType destArrayType = (PsiArrayType)destType;
            PsiType srcComponentType = srcArrayType.getComponentType();
            PsiType destComponentType = destArrayType.getComponentType();
            if (!(srcComponentType instanceof PsiPrimitiveType)) {
                if (!destComponentType.isAssignableFrom(srcComponentType)) {
                    this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
                }
            } else if (!destComponentType.equals(srcComponentType)) {
                this.registerError((PsiElement)dest, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor6", srcType.getCanonicalText(), destType.getCanonicalText()));
            }
        }

        private void checkRanges(@NotNull PsiExpression src, @NotNull PsiExpression srcPos, @NotNull PsiExpression dest, @NotNull PsiExpression destPos, @NotNull PsiExpression length, @NotNull PsiMethodCallExpression call) {
            LongRangeSet destRange;
            CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(src);
            if (result == null) {
                return;
            }
            LongRangeSet srcLengthSet = DfIntType.extractRange(SpecialField.ARRAY_LENGTH.getFromQualifier(result.getDfType(src)));
            LongRangeSet destLengthSet = DfIntType.extractRange(SpecialField.ARRAY_LENGTH.getFromQualifier(result.getDfType(dest)));
            LongRangeSet srcPosSet = DfIntType.extractRange(result.getDfType(srcPos));
            LongRangeSet destPosSet = DfIntType.extractRange(result.getDfType(destPos));
            LongRangeSet lengthSet = DfIntType.extractRange(result.getDfType(length));
            LongRangeSet srcPossibleLengthToCopy = srcLengthSet.minus(srcPosSet, false);
            LongRangeSet destPossibleLengthToCopy = destLengthSet.minus(destPosSet, false);
            long lengthMin = lengthSet.min();
            if (lengthMin > destPossibleLengthToCopy.max()) {
                this.registerError((PsiElement)length, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor.length.bigger.dest", lengthSet.toString()));
                return;
            }
            if (lengthMin > srcPossibleLengthToCopy.max()) {
                this.registerError((PsiElement)length, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor.length.bigger.src", lengthSet.toString()));
                return;
            }
            if (!SuspiciousSystemArraycopyVisitor.isTheSameArray(src, dest)) {
                return;
            }
            LongRangeSet srcRange = SuspiciousSystemArraycopyVisitor.getDefiniteRange(srcPosSet, lengthSet);
            if (srcRange.intersects(destRange = SuspiciousSystemArraycopyVisitor.getDefiniteRange(destPosSet, lengthSet))) {
                PsiElement name2 = call.getMethodExpression().getReferenceNameElement();
                PsiMethodCallExpression elementToHighlight = name2 == null ? call : name2;
                this.registerError((PsiElement)elementToHighlight, InspectionGadgetsBundle.message("suspicious.system.arraycopy.problem.descriptor.ranges.intersect", new Object[0]));
            }
        }

        @NotNull
        private static LongRangeSet getDefiniteRange(@NotNull LongRangeSet startSet, @NotNull LongRangeSet lengthSet) {
            LongRangeSet lengthMinusOne;
            long minRightBorder;
            long maxLeftBorder = startSet.max();
            if (maxLeftBorder > (minRightBorder = startSet.plus(lengthMinusOne = lengthSet.minus(LongRangeSet.point(1L), false), false).min())) {
                return LongRangeSet.empty();
            }
            return LongRangeSet.range(maxLeftBorder, minRightBorder);
        }

        private static boolean isTheSameArray(@NotNull PsiExpression src, @NotNull PsiExpression dest) {
            PsiReferenceExpression srcReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)src), PsiReferenceExpression.class);
            PsiReferenceExpression destReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)dest), PsiReferenceExpression.class);
            if (srcReference == null || destReference == null) {
                return false;
            }
            PsiElement srcVariable = srcReference.resolve();
            PsiElement destVariable = destReference.resolve();
            return srcVariable != null && srcVariable == destVariable;
        }
    }
}

