/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationInMessageFormatCallInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.concatenation.in.message.format.call.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        String referenceName = referenceExpression.getReferenceName();
        return new StringConcatenationInFormatCallFix(referenceName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInMessageFormatCallVisitor();
    }

    private static class StringConcatenationInMessageFormatCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInMessageFormatCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!StringConcatenationInMessageFormatCallVisitor.isMessageFormatCall(expression2)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType type2 = firstArgument.getType();
            if (type2 == null) {
                return;
            }
            int formatArgumentIndex = "java.util.Locale".equals(type2.getCanonicalText()) && arguments.length > 1 ? 1 : 0;
            PsiExpression formatArgument = arguments[formatArgumentIndex];
            PsiType formatArgumentType = formatArgument.getType();
            if (formatArgumentType == null || !formatArgumentType.equalsToText("java.lang.String")) {
                return;
            }
            if (!(formatArgument instanceof PsiBinaryExpression)) {
                return;
            }
            if (PsiUtil.isConstantExpression((PsiExpression)formatArgument)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)formatArgument;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (lhsType == null || !lhsType.equalsToText("java.lang.String")) {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)formatArgument, rhs);
        }

        private static boolean isMessageFormatCall(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"format".equals(referenceName)) {
                return false;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (!(qualifierExpression2 instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiClass aClass = (PsiClass)target;
            return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.text.MessageFormat");
        }
    }

    private static class StringConcatenationInFormatCallFix
    extends InspectionGadgetsFix {
        private final String variableName;

        StringConcatenationInFormatCallFix(String variableName2) {
            this.variableName = variableName2;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("string.concatenation.in.format.call.quickfix", this.variableName);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("string.concatenation.in.format.call.fix.family.name", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiElement parent = binaryExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression[] expressions2 = expressionList.getExpressions();
            int parameter2 = expressions2.length - 1;
            expressionList.add((PsiElement)rhs);
            Object constant = ExpressionUtils.computeConstantExpression(lhs);
            if (constant instanceof String) {
                PsiExpression newExpression = StringConcatenationInFormatCallFix.addParameter(lhs, parameter2);
                if (newExpression == null) {
                    expressionList.addAfter((PsiElement)lhs, (PsiElement)binaryExpression);
                } else {
                    expressionList.addAfter((PsiElement)newExpression, (PsiElement)binaryExpression);
                }
            } else {
                expressionList.addAfter((PsiElement)lhs, (PsiElement)binaryExpression);
            }
            binaryExpression.delete();
        }

        @Nullable
        private static PsiExpression addParameter(PsiExpression expression2, int parameterNumber) {
            if (expression2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return null;
                }
                PsiExpression newExpression = StringConcatenationInFormatCallFix.addParameter(rhs, parameterNumber);
                if (newExpression == null) {
                    return null;
                }
                rhs.replace((PsiElement)newExpression);
                return expression2;
            }
            if (expression2 instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
                Object value2 = literalExpression.getValue();
                if (!(value2 instanceof String)) {
                    return null;
                }
                Project project = expression2.getProject();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                return factory.createExpressionFromText("\"" + value2 + '{' + parameterNumber + "}\"", null);
            }
            return null;
        }
    }
}

