/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class StaticCallOnSubclassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "StaticMethodReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        return InspectionGadgetsBundle.message("static.method.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticCallOnSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticCallOnSubclassVisitor();
    }

    private static class StaticCallOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticCallOnSubclassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            this.checkCallOnSubclass(method, methodExpression);
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement resolve2;
            super.visitMethodReferenceExpression(expression2);
            if (PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression2) && (resolve2 = expression2.resolve()) instanceof PsiMethod) {
                this.checkCallOnSubclass((PsiMethod)resolve2, (PsiReferenceExpression)expression2);
            }
        }

        private void checkCallOnSubclass(@NotNull PsiMethod method, PsiReferenceExpression methodExpression) {
            if (!method.hasModifierProperty("static")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)referent;
            PsiClass declaringClass = method.getContainingClass();
            if (declaringClass == null) {
                return;
            }
            if (declaringClass.equals(referencedClass) || declaringClass.isInterface()) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)methodExpression.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible((PsiMember)declaringClass, (PsiElement)methodExpression, null)) {
                return;
            }
            PsiElement referenceNameElement2 = methodExpression.getReferenceNameElement();
            if (referenceNameElement2 == null) {
                return;
            }
            this.registerError(referenceNameElement2, declaringClass, referencedClass);
        }
    }

    private static class StaticCallOnSubclassFix
    extends InspectionGadgetsFix {
        private StaticCallOnSubclassFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("static.method.via.subclass.rationalize.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIdentifier name2 = (PsiIdentifier)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiIdentifier.class);
            if (name2 == null) {
                return;
            }
            PsiReferenceExpression expression2 = (PsiReferenceExpression)ObjectUtils.tryCast((Object)name2.getParent(), PsiReferenceExpression.class);
            if (expression2 == null) {
                return;
            }
            if (expression2 instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression2;
                PsiClass containingClass;
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiMethod && (containingClass = ((PsiMethod)resolve2).getContainingClass()) != null && (qualifierExpression2 = expression2.getQualifierExpression()) instanceof PsiReferenceExpression) {
                    ((PsiReferenceExpression)qualifierExpression2).bindToElement((PsiElement)containingClass);
                }
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            PsiExpressionList argumentList = call.getArgumentList();
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            CommentTracker commentTracker = new CommentTracker();
            String argText = commentTracker.text((PsiElement)argumentList);
            String typeArgText = commentTracker.text((PsiElement)call.getTypeArgumentList());
            String methodName = expression2.getReferenceName();
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, containingClassName + '.' + typeArgText + methodName + argText, commentTracker);
        }
    }
}

