/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceAllDotInspection
extends BaseInspection {
    private static final String REGEX_META_CHARS = ".$|()[{^?*+\\";

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        String methodName = methodCallExpression.getMethodExpression().getReferenceName();
        return InspectionGadgetsBundle.message("replace.all.dot.problem.descriptor", methodName);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "SuspiciousRegexArgument";
    }

    @Nullable
    public String getAlternativeID() {
        return "ReplaceAllDot";
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression expression2 = (PsiExpression)infos[1];
        if (!(expression2 instanceof PsiLiteralExpression)) {
            return null;
        }
        return new EscapeCharacterFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReplaceAllDotVisitor();
    }

    private static class ReplaceAllDotVisitor
    extends BaseInspectionVisitor {
        private static final CallMatcher.Simple MATCHER = CallMatcher.instanceCall("java.lang.String", "replaceAll", "split");

        private ReplaceAllDotVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!MATCHER.test(expression2)) {
                return;
            }
            PsiExpression argument = (PsiExpression)ArrayUtil.getFirstElement((Object[])expression2.getArgumentList().getExpressions());
            if (!PsiUtil.isConstantExpression((PsiExpression)argument) || !ExpressionUtils.hasStringType(argument)) {
                return;
            }
            String value2 = (String)ExpressionUtils.computeConstantExpression(argument);
            if (!ReplaceAllDotVisitor.isRegexMetaChar(value2, !this.isOnTheFly())) {
                return;
            }
            this.registerError((PsiElement)argument, expression2, argument);
        }

        private static boolean isRegexMetaChar(String s, boolean includeErrors) {
            return s != null && s.length() == 1 && (includeErrors ? ReplaceAllDotInspection.REGEX_META_CHARS : ".$|^").contains(s);
        }
    }

    private static class EscapeCharacterFix
    extends InspectionGadgetsFix {
        private EscapeCharacterFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("replace.all.dot.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression expression2 = (PsiLiteralExpression)element;
            String text2 = expression2.getText();
            StringBuilder newExpression = new StringBuilder();
            int length = text2.length();
            for (int i = 0; i < length; ++i) {
                char c = text2.charAt(i);
                if (StringUtil.containsChar((String)ReplaceAllDotInspection.REGEX_META_CHARS, (char)c)) {
                    newExpression.append("\\\\");
                }
                newExpression.append(c);
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression.toString());
        }
    }
}

