/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.FormatDecode;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedFormatStringInspection
extends BaseInspection {
    final List<String> classNames = new ArrayList<String>();
    final List<String> methodNames = new ArrayList<String>();
    @NonNls
    public String additionalClasses = "";
    @NonNls
    public String additionalMethods = "";

    public MalformedFormatStringInspection() {
        MalformedFormatStringInspection.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspection.parseString(this.additionalMethods, this.methodNames);
    }

    public JComponent createOptionsPanel() {
        ListWrappingTableModel classTableModel = new ListWrappingTableModel(this.classNames, InspectionGadgetsBundle.message("string.format.class.column.name", new Object[0]));
        JPanel classChooserPanel = UiUtils.createAddRemoveTreeClassChooserPanel(new ListTable(classTableModel), InspectionGadgetsBundle.message("string.format.choose.class", new Object[0]), new String[0]);
        ListWrappingTableModel methodTableModel = new ListWrappingTableModel(this.methodNames, InspectionGadgetsBundle.message("string.format.class.method.name", new Object[0]));
        JPanel methodPanel = UiUtils.createAddRemovePanel(new ListTable(methodTableModel));
        JPanel panel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(panel2, 1);
        panel2.setLayout(boxLayout);
        panel2.add(classChooserPanel);
        panel2.add(methodPanel);
        return panel2;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        super.readSettings(node);
        MalformedFormatStringInspection.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspection.parseString(this.additionalMethods, this.methodNames);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.additionalClasses = MalformedFormatStringInspection.formatString(this.classNames);
        this.additionalMethods = MalformedFormatStringInspection.formatString(this.methodNames);
        super.writeSettings(node);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object value2 = infos[0];
        if (value2 instanceof Exception) {
            Exception exception = (Exception)value2;
            String message2 = exception.getMessage();
            if (message2 != null) {
                return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.illegal", message2);
            }
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.malformed", new Object[0]);
        }
        FormatDecode.Validator[] validators = (FormatDecode.Validator[])value2;
        int argumentCount = (Integer)infos[1];
        if (validators.length < argumentCount) {
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.many.arguments", argumentCount, validators.length);
        }
        if (validators.length > argumentCount) {
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.few.arguments", argumentCount, validators.length);
        }
        PsiType argumentType = (PsiType)infos[2];
        FormatDecode.Validator validator2 = (FormatDecode.Validator)infos[3];
        return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.arguments.do.not.match.type", argumentType.getPresentableText(), validator2.getSpecifier());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedFormatStringVisitor();
    }

    private class MalformedFormatStringVisitor
    extends BaseInspectionVisitor {
        private MalformedFormatStringVisitor() {
        }

        private int findFirstStringArgumentIndex(PsiExpression[] expressions2) {
            int length = expressions2.length;
            for (int i = 0; i < length; ++i) {
                PsiExpression expression2 = expressions2[i];
                if (!ExpressionUtils.hasStringType(expression2)) continue;
                return i;
            }
            return -1;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiExpression argument;
            PsiType argumentType;
            FormatDecode.Validator[] validators;
            int formatArgumentIndex;
            PsiExpression formatArgument;
            super.visitMethodCallExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (FormatUtils.STRING_FORMATTED.matches((PsiExpression)expression2)) {
                formatArgument = expression2.getMethodExpression().getQualifierExpression();
                formatArgumentIndex = 0;
            } else {
                if (!FormatUtils.isFormatCall(expression2, MalformedFormatStringInspection.this.methodNames, MalformedFormatStringInspection.this.classNames)) {
                    return;
                }
                formatArgumentIndex = this.findFirstStringArgumentIndex(arguments);
                if (formatArgumentIndex < 0) {
                    return;
                }
                formatArgument = arguments[formatArgumentIndex];
                ++formatArgumentIndex;
            }
            if (!ExpressionUtils.hasStringType(formatArgument) || !PsiUtil.isConstantExpression((PsiExpression)formatArgument)) {
                return;
            }
            PsiType formatType = formatArgument.getType();
            if (formatType == null) {
                return;
            }
            String value2 = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)formatArgument, (PsiType)formatType);
            if (value2 == null) {
                return;
            }
            int argumentCount = arguments.length - formatArgumentIndex;
            try {
                validators = FormatDecode.decode(value2, argumentCount);
            }
            catch (FormatDecode.IllegalFormatException e) {
                this.registerError((PsiElement)formatArgument, e);
                return;
            }
            if (argumentCount == 1 && (argumentType = (argument = this.resolveIfPossible(arguments[formatArgumentIndex])).getType()) instanceof PsiArrayType) {
                PsiArrayInitializerExpression arrayInitializer;
                if (argument instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)argument;
                    arrayInitializer = newExpression.getArrayInitializer();
                } else if (argument instanceof PsiArrayInitializerExpression) {
                    arrayInitializer = (PsiArrayInitializerExpression)argument;
                } else {
                    return;
                }
                if (arrayInitializer == null) {
                    return;
                }
                arguments = arrayInitializer.getInitializers();
                argumentCount = arguments.length;
                formatArgumentIndex = 0;
            }
            if (validators.length != argumentCount) {
                this.registerMethodCallError(expression2, validators, argumentCount);
                return;
            }
            for (int i = 0; i < validators.length; ++i) {
                PsiType preciseType;
                FormatDecode.Validator validator2 = validators[i];
                PsiExpression argument2 = arguments[i + formatArgumentIndex];
                PsiType argumentType2 = argument2.getType();
                if (argumentType2 == null || validator2 == null || validator2.valid(argumentType2) || (preciseType = TypeConstraint.fromDfType(CommonDataflow.getDfType(argument2)).getPsiType(expression2.getProject())) != null && validator2.valid(preciseType)) continue;
                this.registerError((PsiElement)argument2, validators, argumentCount, argumentType2, validator2);
            }
        }

        private PsiExpression resolveIfPossible(PsiExpression expression2) {
            PsiVariable variable;
            PsiExpression initializer;
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable && target.getContainingFile() == expression2.getContainingFile() && (initializer = (variable = (PsiVariable)target).getInitializer()) != null) {
                return initializer;
            }
            return expression2;
        }
    }
}

