/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.annotation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaAnnotationWithoutRuntimeRetentionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Collection<String> ourAnnotations = new HashSet<String>();

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (!aClass.isAnnotationType()) {
            return null;
        }
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)aClass, ourAnnotations)) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"java.lang.annotation.Retention"});
            if (annotation == null) {
                String runtimeRef = StringUtil.getQualifiedName((String)"java.lang.annotation.RetentionPolicy", (String)"RUNTIME");
                PsiAnnotation newAnnotation = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createAnnotationFromText("@Retention(" + runtimeRef + ")", (PsiElement)aClass);
                AddAnnotationPsiFix annotationPsiFix = new AddAnnotationPsiFix("java.lang.annotation.Retention", (PsiModifierListOwner)aClass, newAnnotation.getParameterList().getAttributes(), new String[0]);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)ObjectUtils.notNull((Object)aClass.getNameIdentifier(), (Object)aClass), InspectionGadgetsBundle.message("inspection.meta.annotation.without.runtime.description", aClass.getName()), (LocalQuickFix)annotationPsiFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                return new ProblemDescriptor[]{descriptor};
            }
            PsiAnnotationMemberValue attributeValue = annotation.findDeclaredAttributeValue("value");
            if (attributeValue == null || !attributeValue.getText().contains("RUNTIME")) {
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)ObjectUtils.notNull((Object)aClass.getNameIdentifier(), (Object)aClass), InspectionGadgetsBundle.message("inspection.meta.annotation.without.runtime.description", aClass.getName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                return new ProblemDescriptor[]{descriptor};
            }
        }
        return null;
    }

    static {
        ourAnnotations.add("org.junit.jupiter.api.Test");
        ourAnnotations.add("org.junit.jupiter.api.Nested");
        ourAnnotations.add("org.junit.jupiter.api.RepeatedTest");
        ourAnnotations.add("org.junit.jupiter.params.ParameterizedTest");
    }
}

