/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassReferencesSubclassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String containingClassName = element.getName();
        Boolean isAnonymous = (Boolean)infos[1];
        if (isAnonymous.booleanValue()) {
            return InspectionGadgetsBundle.message("class.references.subclass.problem.descriptor.anonymous", containingClassName);
        }
        return InspectionGadgetsBundle.message("class.references.subclass.problem.descriptor", containingClassName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassReferencesSubclassVisitor();
    }

    private static class ClassReferencesSubclassVisitor
    extends BaseInspectionVisitor {
        private ClassReferencesSubclassVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            PsiTypeElement typeElement = variable.getTypeElement();
            this.checkTypeElement(typeElement);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiTypeElement typeElement = method.getReturnTypeElement();
            this.checkTypeElement(typeElement);
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression2) {
            PsiTypeElement typeElement = expression2.getCheckType();
            this.checkTypeElement(typeElement);
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
            PsiTypeElement typeElement = expression2.getCastType();
            this.checkTypeElement(typeElement);
        }

        public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression2) {
            PsiTypeElement typeElement = expression2.getOperand();
            this.checkTypeElement(typeElement);
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            if (typeElement == null) {
                return;
            }
            PsiType type2 = typeElement.getType();
            PsiType componentType = type2.getDeepComponentType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)componentType);
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)typeElement);
            if (!ClassReferencesSubclassVisitor.isSubclass(aClass, parentClass)) {
                return;
            }
            this.registerError((PsiElement)typeElement, parentClass, Boolean.FALSE);
        }

        private static boolean isSubclass(@Nullable PsiClass childClass, @Nullable PsiClass parent) {
            if (childClass == null) {
                return false;
            }
            if (parent == null) {
                return false;
            }
            return childClass.isInheritor(parent, true);
        }
    }
}

