/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.GroupDisplayNameUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends AbstractBaseJavaLocalInspectionTool {
    private String m_shortName = null;

    @NotNull
    public String getShortName() {
        if (this.m_shortName == null) {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name2 = aClass.getSimpleName();
            this.m_shortName = InspectionProfileEntry.getShortName((String)name2);
            if (this.m_shortName.equals(name2)) {
                throw new AssertionError((Object)("class name must end with 'Inspection' to correctly calculate the short name: " + name2));
            }
        }
        return this.m_shortName;
    }

    @Nls
    @NotNull
    public final String getGroupDisplayName() {
        return GroupDisplayNameUtil.getGroupDisplayName(((Object)((Object)this)).getClass());
    }

    @NotNull
    protected abstract @InspectionMessage String buildErrorString(Object ... var1);

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return null;
    }

    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        return InspectionGadgetsFix.EMPTY_ARRAY;
    }

    protected void writeBooleanOption(@NotNull Element node, @NotNull @NonNls String property, boolean defaultValueToIgnore) {
        Boolean value2 = (Boolean)ReflectionUtil.getField(((Object)((Object)this)).getClass(), (Object)((Object)this), Boolean.TYPE, (String)property);
        assert (value2 != null);
        if (defaultValueToIgnore == value2) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", property).setAttribute("value", value2.toString()));
    }

    protected void defaultWriteSettings(@NotNull Element node, final String ... excludedProperties) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)node, (DefaultJDOMExternalizer.JDOMFilter)new DefaultJDOMExternalizer.JDOMFilter(){

            public boolean isAccept(@NotNull Field field) {
                String name2 = field.getName();
                for (String property : excludedProperties) {
                    if (!name2.equals(property)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public abstract BaseInspectionVisitor buildVisitor();

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        assert (file.isPhysical());
        if (!this.shouldInspect(file)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        BaseInspectionVisitor visitor2 = this.buildVisitor();
        visitor2.setProblemsHolder(holder);
        visitor2.setOnTheFly(isOnTheFly);
        visitor2.setInspection(this);
        return visitor2;
    }

    public boolean shouldInspect(PsiFile file) {
        return true;
    }

    protected JFormattedTextField prepareNumberEditor(final @NonNls String fieldName) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        final JFormattedTextField valueField = new JFormattedTextField(formatter);
        Object value2 = ReflectionUtil.getField(((Object)((Object)this)).getClass(), (Object)((Object)this), null, (String)fieldName);
        valueField.setValue(value2);
        valueField.setColumns(4);
        valueField.setMinimumSize(valueField.getPreferredSize());
        UIUtil.fixFormattedField((JFormattedTextField)valueField);
        Document document = valueField.getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent evt) {
                try {
                    valueField.commitEdit();
                    Number number = (Number)valueField.getValue();
                    ReflectionUtil.setField(((Object)((Object)BaseInspection.this)).getClass(), (Object)((Object)BaseInspection.this), Integer.TYPE, (String)fieldName, (Object)number.intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        return valueField;
    }

    @SafeVarargs
    public static void parseString(String string, List<String> ... outs) {
        List strings = StringUtil.split((String)string, (String)",");
        for (List<String> out : outs) {
            out.clear();
        }
        int iMax = strings.size();
        for (int i = 0; i < iMax; i += outs.length) {
            for (int j = 0; j < outs.length; ++j) {
                List<String> out;
                out = outs[j];
                if (i + j >= iMax) {
                    out.add("");
                    continue;
                }
                out.add((String)strings.get(i + j));
            }
        }
    }

    @SafeVarargs
    public static String formatString(List<String> ... strings) {
        StringBuilder buffer = new StringBuilder();
        int size = strings[0].size();
        if (size > 0) {
            BaseInspection.formatString(strings, 0, buffer);
            for (int i = 1; i < size; ++i) {
                buffer.append(',');
                BaseInspection.formatString(strings, i, buffer);
            }
        }
        return buffer.toString();
    }

    private static void formatString(List<String>[] strings, int index, StringBuilder out) {
        out.append(strings[0].get(index));
        for (int i = 1; i < strings.length; ++i) {
            out.append(',');
            out.append(strings[i].get(index));
        }
    }
}

