/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.ConfigFileMetaDataRegistry;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import com.intellij.util.descriptors.impl.ConfigFileInfoSetImpl;
import com.intellij.util.descriptors.impl.ConfigFileMetaDataRegistryImpl;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class ConfigFileFactoryImpl
extends ConfigFileFactory {
    private static final Logger LOG = Logger.getInstance(ConfigFileFactoryImpl.class);

    public ConfigFileMetaDataProvider createMetaDataProvider(ConfigFileMetaData ... metaData) {
        return new ConfigFileMetaDataRegistryImpl(metaData);
    }

    public ConfigFileMetaDataRegistry createMetaDataRegistry() {
        return new ConfigFileMetaDataRegistryImpl();
    }

    public ConfigFileInfoSet createConfigFileInfoSet(ConfigFileMetaDataProvider metaDataProvider) {
        return new ConfigFileInfoSetImpl(metaDataProvider);
    }

    public ConfigFileContainer createConfigFileContainer(Project project, ConfigFileMetaDataProvider metaDataProvider, ConfigFileInfoSet configuration) {
        return new ConfigFileContainerImpl(project, metaDataProvider, (ConfigFileInfoSetImpl)configuration);
    }

    private static String getText(String templateName, @Nullable Project project) throws IOException {
        FileTemplateManager templateManager = project == null ? FileTemplateManager.getDefaultInstance() : FileTemplateManager.getInstance((Project)project);
        FileTemplate template = templateManager.getJ2eeTemplate(templateName);
        if (template == null) {
            return "";
        }
        return template.getText(templateManager.getDefaultProperties());
    }

    @Nullable
    public VirtualFile createFile(@Nullable Project project, String url, ConfigFileVersion version, boolean forceNew) {
        return this.createFileFromTemplate(project, url, version.getTemplateName(), forceNew);
    }

    @Nullable
    private VirtualFile createFileFromTemplate(@Nullable Project project, String url, String templateName, boolean forceNew) {
        File file;
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile existingFile = fileSystem.refreshAndFindFileByIoFile(file = new File(VfsUtilCore.urlToPath((String)url)));
        if (existingFile != null) {
            existingFile.refresh(false, false);
            if (!existingFile.isValid()) {
                existingFile = null;
            }
        }
        if (existingFile != null && !forceNew) {
            return existingFile;
        }
        try {
            VirtualFile childData;
            String text2 = ConfigFileFactoryImpl.getText(templateName, project);
            if (existingFile == null || existingFile.isDirectory()) {
                VirtualFile virtualFile;
                if (!FileUtil.createParentDirs((File)file) || (virtualFile = fileSystem.refreshAndFindFileByIoFile(file.getParentFile())) == null) {
                    throw new IOException(IdeBundle.message((String)"error.message.unable.to.create.file", (Object[])new Object[]{file.getPath()}));
                }
                childData = virtualFile.createChildData((Object)this, file.getName());
            } else {
                childData = existingFile;
            }
            VfsUtil.saveText((VirtualFile)childData, (String)text2);
            return childData;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)JavaUiBundle.message("message.text.error.creating.deployment.descriptor", e.getLocalizedMessage()), (String)JavaUiBundle.message("message.text.creating.deployment.descriptor", new Object[0])));
            return null;
        }
    }

    public ConfigFileContainer createSingleFileContainer(Project project, ConfigFileMetaData metaData) {
        ConfigFileMetaDataProvider metaDataProvider = this.createMetaDataProvider(metaData);
        return this.createConfigFileContainer(project, metaDataProvider, this.createConfigFileInfoSet(metaDataProvider));
    }
}

