/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration.createTest;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.testIntegration.TestFramework;
import com.intellij.testIntegration.createTest.JavaTestGenerator;
import com.intellij.testIntegration.createTest.MissedTestsDialog;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GenerateMissedTestsAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.text.generate.missed.test.methods", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!TestFramework.EXTENSION_NAME.hasAnyExtensions()) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return false;
        }
        if (!((PsiMethod)parent).hasModifierProperty("public") || ((PsiMethod)parent).hasModifierProperty("abstract")) {
            return false;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        return aClass != null && TestFrameworks.detectFramework((PsiClass)aClass) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiClass srcClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (srcClass == null) {
            return;
        }
        Collection testClasses = TestFinderHelper.findTestsForClass((PsiElement)srcClass);
        if (testClasses.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, "No tests found.");
            return;
        }
        if (testClasses.size() == 1) {
            GenerateMissedTestsAction.generateMissedTests((PsiClass)ContainerUtil.getFirstItem((Collection)testClasses), srcClass, editor);
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder(new ArrayList(testClasses)).setRenderer((ListCellRenderer)((Object)new PsiClassListCellRenderer())).setItemChosenCallback(selectedClass -> GenerateMissedTestsAction.generateMissedTests((PsiClass)selectedClass, srcClass, editor)).setTitle(JavaBundle.message((String)"popup.title.choose.test", (Object[])new Object[0])).createPopup().showInBestPositionFor(editor);
    }

    private static void generateMissedTests(PsiClass testClass, PsiClass srcClass, Editor srcEditor) {
        if (testClass != null) {
            TestFramework framework = TestFrameworks.detectFramework((PsiClass)testClass);
            if (framework != null) {
                Project project = testClass.getProject();
                Editor editor = CodeInsightUtil.positionCursorAtLBrace(project, testClass.getContainingFile(), testClass);
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{testClass})) {
                    return;
                }
                MissedTestsDialog dialog = new MissedTestsDialog(project, srcClass, testClass, framework);
                if (dialog.showAndGet()) {
                    WriteCommandAction.runWriteCommandAction((Project)project, () -> JavaTestGenerator.addTestMethods(editor, testClass, srcClass, framework, dialog.getSelectedMethods(), false, false));
                }
            } else {
                HintManager.getInstance().showErrorHint(srcEditor, "Failed to detect test framework for " + testClass.getQualifiedName());
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

