/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import com.intellij.testIntegration.TestFailedLineManager;
import com.intellij.testIntegration.TestFramework;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRunLineMarkerProvider
extends RunLineMarkerContributor {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement e) {
        if (this.isIdentifier(e)) {
            TestFramework framework;
            PsiElement element = e.getParent();
            if (element instanceof PsiClass && (framework = TestFrameworks.detectFramework((PsiClass)((PsiClass)element))) != null && framework.isTestClass(element)) {
                String url = "java:suite://" + ClassUtil.getJVMClassName((PsiClass)((PsiClass)element));
                TestStateStorage.Record state = TestStateStorage.getInstance((Project)e.getProject()).getState(url);
                return TestRunLineMarkerProvider.getInfo(state, true);
            }
            if (element instanceof PsiMethod) {
                TestFailedLineManager.TestInfo testInfo = TestFailedLineManager.getInstance(e.getProject()).getTestInfo((PsiMethod)element);
                return testInfo == null ? null : TestRunLineMarkerProvider.getInfo(testInfo.myRecord, false);
            }
        }
        return null;
    }

    @NotNull
    private static RunLineMarkerContributor.Info getInfo(TestStateStorage.Record state, boolean isClass) {
        return RunLineMarkerContributor.withExecutorActions((Icon)TestRunLineMarkerProvider.getTestStateIcon((TestStateStorage.Record)state, (boolean)isClass));
    }

    protected boolean isIdentifier(PsiElement e) {
        return e instanceof PsiIdentifier;
    }
}

