/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.spi.SPIFileType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SPIFile
extends PsiFileBase {
    public SPIFile(@NotNull FileViewProvider viewProvider) {
        super(viewProvider, (Language)SPILanguage.INSTANCE);
    }

    @NotNull
    public PsiReference getReference() {
        return new SPIFileName2ClassReference((PsiFile)this, (PsiClass)ReadAction.compute(() -> ClassUtil.findPsiClass((PsiManager)this.getManager(), (String)this.getName(), null, (boolean)true, (GlobalSearchScope)this.getResolveScope())));
    }

    public PsiReference @NotNull [] getReferences() {
        return (PsiReference[])ReadAction.compute(() -> {
            int d;
            ArrayList<SPIFileName2PackageReference> refs = new ArrayList<SPIFileName2PackageReference>();
            int idx = 0;
            String fileName = this.getName();
            while ((d = fileName.indexOf(".", idx)) > -1) {
                PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(fileName.substring(0, d));
                if (aPackage != null) {
                    refs.add(new SPIFileName2PackageReference((PsiFile)this, (PsiElement)aPackage));
                }
                idx = d + 1;
            }
            PsiReference reference = this.getReference();
            PsiElement resolve2 = reference.resolve();
            while (resolve2 instanceof PsiClass) {
                String jvmClassName;
                if ((resolve2 = ((PsiClass)resolve2).getContainingClass()) == null || (jvmClassName = ClassUtil.getJVMClassName((PsiClass)((PsiClass)resolve2))) == null) continue;
                refs.add(new SPIFileName2PackageReference((PsiFile)this, resolve2));
            }
            refs.add((SPIFileName2PackageReference)reference);
            return refs.toArray(PsiReference.EMPTY_ARRAY);
        });
    }

    @NotNull
    public FileType getFileType() {
        return SPIFileType.INSTANCE;
    }

    private static class SPIFileName2PackageReference
    extends PsiReferenceBase<PsiFile> {
        private final PsiElement myPackageOrContainingClass;

        SPIFileName2PackageReference(PsiFile file, @NotNull PsiElement psiPackage) {
            super((PsiElement)file, new TextRange(0, 0), false);
            this.myPackageOrContainingClass = psiPackage;
        }

        @NotNull
        public String getCanonicalText() {
            return this.myPackageOrContainingClass instanceof PsiPackage ? ((PsiPackage)this.myPackageOrContainingClass).getQualifiedName() : ClassUtil.getJVMClassName((PsiClass)((PsiClass)this.myPackageOrContainingClass));
        }

        @Nullable
        public PsiElement resolve() {
            return this.myPackageOrContainingClass;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            String newPackageQName = StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)this.getCanonicalText()), (String)newElementName);
            return ((PsiFile)this.getElement()).setName(newPackageQName + ((PsiFile)this.getElement()).getName().substring(this.getCanonicalText().length()));
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String className2;
            if (element instanceof PsiPackage) {
                return this.handleElementRename(((PsiPackage)element).getQualifiedName());
            }
            if (element instanceof PsiClass && (className2 = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null) {
                return this.handleElementRename(className2);
            }
            return this.getElement();
        }
    }

    private static class SPIFileName2ClassReference
    extends PsiReferenceBase<PsiFile> {
        private final PsiClass myClass;

        SPIFileName2ClassReference(PsiFile file, PsiClass aClass) {
            super((PsiElement)file, new TextRange(0, 0), false);
            this.myClass = aClass;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myClass;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            String className2;
            if (this.myClass != null && (className2 = ClassUtil.getJVMClassName((PsiClass)this.myClass)) != null) {
                String newFileName = className2.substring(0, className2.lastIndexOf(this.myClass.getName())) + newElementName;
                return ((PsiFile)this.getElement()).setName(newFileName);
            }
            return this.getElement();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            String className2;
            if (element instanceof PsiClass && (className2 = ClassUtil.getJVMClassName((PsiClass)((PsiClass)element))) != null) {
                return ((PsiFile)this.getElement()).setName(className2);
            }
            return this.getElement();
        }
    }
}

