/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceLeafValueClassNode;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class SliceNullnessAnalyzerBase {
    @NotNull
    private final SliceLeafEquality myLeafEquality;
    @NotNull
    private final SliceLanguageSupportProvider myProvider;

    public SliceNullnessAnalyzerBase(@NotNull SliceLeafEquality leafEquality, @NotNull SliceLanguageSupportProvider provider) {
        this.myLeafEquality = leafEquality;
        this.myProvider = provider;
    }

    private void groupByNullness(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2) {
        SliceRootNode root = this.createNewTree(result, oldRoot, map2);
        SliceUsage rootUsage = (SliceUsage)((SliceNode)oldRoot.getCachedChildren().get(0)).getValue();
        SliceManager.getInstance((Project)Objects.requireNonNull(root.getProject())).createToolWindow(true, root, true, SliceManager.getElementDescription(null, (PsiElement)Objects.requireNonNull(rootUsage).getElement(), (String)" Grouped by Nullness"));
    }

    @NotNull
    public SliceRootNode createNewTree(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2) {
        SliceRootNode root = oldRoot.copy();
        assert (oldRoot.getCachedChildren().size() == 1);
        SliceNode oldRootStart = (SliceNode)oldRoot.getCachedChildren().get(0);
        root.setChanged();
        root.targetEqualUsages.clear();
        ArrayList children = new ArrayList();
        ContainerUtil.addIfNotNull(children, (Object)((Object)this.createValueRootNode(result, oldRoot, map2, root, oldRootStart, "Null Values", 0)));
        ContainerUtil.addIfNotNull(children, (Object)((Object)this.createValueRootNode(result, oldRoot, map2, root, oldRootStart, "NotNull Values", 1)));
        ContainerUtil.addIfNotNull(children, (Object)((Object)this.createValueRootNode(result, oldRoot, map2, root, oldRootStart, "Other Values", 2)));
        root.setChildren(children);
        return root;
    }

    private SliceLeafValueClassNode createValueRootNode(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2, SliceRootNode root, SliceNode oldRootStart, String nodeName, int group) {
        Collection groupedByValue = (Collection)result.groupedByValue.get(group);
        if (groupedByValue.isEmpty()) {
            return null;
        }
        SliceLeafValueClassNode valueRoot = new SliceLeafValueClassNode(root.getProject(), (SliceNode)root, nodeName);
        THashSet uniqueValues = new THashSet(groupedByValue, (TObjectHashingStrategy)this.myLeafEquality);
        for (PsiElement expression2 : uniqueValues) {
            SliceNode newRoot = SliceLeafAnalyzer.filterTree((SliceNode)oldRootStart, oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                for (PsiElement nullSuspect : SliceNullnessAnalyzerBase.group(oldNode, map2, group)) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullSuspect, (PsiElement)expression2)) continue;
                    return oldNode.copy();
                }
                return null;
            }, (node, children) -> {
                if (!children.isEmpty()) {
                    return true;
                }
                PsiElement element = ((SliceUsage)node.getValue()).getElement();
                if (element == null) {
                    return false;
                }
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression2);
            });
            valueRoot.myCachedChildren.add(new SliceLeafValueRootNode(root.getProject(), (SliceNode)valueRoot, this.myProvider.createRootUsage(expression2, ((SliceUsage)oldRoot.getValue()).params), Collections.singletonList(newRoot)));
        }
        return valueRoot;
    }

    public void startAnalyzeNullness(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish) {
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, NullAnalysisResult> map2 = SliceNullnessAnalyzerBase.createMap();
        String encouragementPiece = " (may very well take the whole day)";
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), JavaRefactoringBundle.message((String)"dataflow.to.here.expand.progress", (Object[])new Object[]{encouragementPiece}), true){

            public void run(@NotNull ProgressIndicator indicator) {
                NullAnalysisResult l = SliceNullnessAnalyzerBase.this.calcNullableLeaves((SliceNode)root, treeStructure, map2);
                leafExpressions.set((Object)l);
            }

            public void onCancel() {
                finish.run();
            }

            public void onSuccess() {
                try {
                    NullAnalysisResult leaves = (NullAnalysisResult)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    SliceNullnessAnalyzerBase.this.groupByNullness(leaves, root, map2);
                }
                finally {
                    finish.run();
                }
            }
        });
    }

    @NotNull
    public static Map<SliceNode, NullAnalysisResult> createMap() {
        return FactoryMap.createMap(k -> new NullAnalysisResult(), () -> new Reference2ObjectOpenHashMap());
    }

    private static NullAnalysisResult node(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls) {
        return nulls.get(node);
    }

    private static Collection<PsiElement> group(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls, int group) {
        return (Collection)nulls.get((Object)node).groupedByValue.get(group);
    }

    @NotNull
    public NullAnalysisResult calcNullableLeaves(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, NullAnalysisResult> map2) {
        final SliceLeafAnalyzer.SliceNodeGuide guide = new SliceLeafAnalyzer.SliceNodeGuide(treeStructure);
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void visit(@NotNull SliceNode element) {
                element.calculateDupNode();
                SliceNullnessAnalyzerBase.node(element, map2).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceNullnessAnalyzerBase.node(element, map2).add(SliceNullnessAnalyzerBase.node(duplicate, map2));
                } else {
                    PsiElement value2 = (PsiElement)ReadAction.compute(() -> ((SliceUsage)element.getValue()).getElement());
                    Nullability nullability = (Nullability)ReadAction.compute(() -> SliceNullnessAnalyzerBase.this.checkNullability(value2));
                    if (nullability == Nullability.NULLABLE) {
                        SliceNullnessAnalyzerBase.group(element, map2, 0).add(value2);
                    } else if (nullability == Nullability.NOT_NULL) {
                        SliceNullnessAnalyzerBase.group(element, map2, 1).add(value2);
                    } else {
                        Collection children = (Collection)ReadAction.compute(() -> ((SliceNode)element).getChildren());
                        if (children.isEmpty()) {
                            SliceNullnessAnalyzerBase.group(element, map2, 2).add(value2);
                        }
                        super.visit((Object)element);
                    }
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                SliceNode parent = guide.getParent(element);
                if (parent != null) {
                    SliceNullnessAnalyzerBase.node(parent, map2).add(SliceNullnessAnalyzerBase.node(element, map2));
                }
            }
        };
        walkingState.visit((Object)root);
        return SliceNullnessAnalyzerBase.node(root, map2);
    }

    @NotNull
    protected Nullability checkNullability(PsiElement element) {
        throw new UnsupportedOperationException();
    }

    public static final class NullAnalysisResult {
        static final int NULLS = 0;
        static final int NOT_NULLS = 1;
        static final int UNKNOWNS = 2;
        final List<ObjectOpenHashSet<PsiElement>> groupedByValue = Arrays.asList(new ObjectOpenHashSet(), new ObjectOpenHashSet(), new ObjectOpenHashSet());

        public void clear() {
            for (Collection collection : this.groupedByValue) {
                collection.clear();
            }
        }

        private void add(NullAnalysisResult duplicate) {
            for (int i = 0; i < this.groupedByValue.size(); ++i) {
                Collection elements = (Collection)this.groupedByValue.get(i);
                Collection other = (Collection)duplicate.groupedByValue.get(i);
                elements.addAll(other);
            }
        }
    }
}

