/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.JavaValueFilter;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class JavaSliceBuilder {
    @NotNull
    private final SliceUsage myParent;
    @NotNull
    private final PsiSubstitutor mySubstitutor;
    private final @Range(from=0L, to=0x7FFFFFFFL) int myIndexNesting;
    @NotNull
    private final String mySyntheticField;
    @NotNull
    private final JavaValueFilter myFilter;

    private JavaSliceBuilder(@NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor, @Range(from=0L, to=0x7FFFFFFFL) int indexNesting, @NotNull String syntheticField, @Nullable SliceValueFilter filter) {
        assert (indexNesting >= 0) : indexNesting;
        this.myParent = parent;
        this.mySubstitutor = substitutor;
        this.myIndexNesting = indexNesting;
        this.mySyntheticField = syntheticField;
        this.myFilter = filter instanceof JavaValueFilter ? (JavaValueFilter)filter : JavaValueFilter.ALLOW_EVERYTHING;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder withSubstitutor(@NotNull PsiSubstitutor substitutor) {
        return new JavaSliceBuilder(this.myParent, substitutor, this.myIndexNesting, this.mySyntheticField, this.myFilter);
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder withSyntheticField(@NotNull String syntheticField) {
        if (syntheticField.equals(this.mySyntheticField)) {
            return this;
        }
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting, syntheticField, this.myFilter);
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder dropSyntheticField() {
        return this.withSyntheticField("");
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder dropNesting() {
        if (this.myIndexNesting == 0) {
            return this;
        }
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, 0, this.mySyntheticField, this.myFilter.withType(DfTypes.TOP));
    }

    boolean process(PsiElement element, Processor<? super SliceUsage> processor2) {
        PsiElement realExpression;
        PsiElement psiElement = realExpression = element.getParent() instanceof DummyHolder ? element.getParent().getContext() : element;
        assert (realExpression != null);
        if (!(realExpression instanceof PsiCompiledElement)) {
            JavaValueFilter filter = this.myFilter.mergeFilter(realExpression);
            SliceAnalysisParams params = this.myParent.params;
            if (filter != params.valueFilter) {
                params = new SliceAnalysisParams(params);
                params.valueFilter = filter;
            }
            return processor2.process((Object)new JavaSliceUsage(realExpression, this.myParent, params, this.mySubstitutor, this.myIndexNesting, this.mySyntheticField));
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder updateNesting(@NotNull Flow anno) {
        if (anno.targetIsContainer() && anno.sourceIsContainer()) {
            return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting, this.mySyntheticField, this.myFilter.unwrap().wrap());
        }
        if (anno.targetIsContainer()) {
            return this.decrementNesting();
        }
        if (anno.sourceIsContainer()) {
            return this.incrementNesting();
        }
        return this;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder withFilter(UnaryOperator<JavaValueFilter> filterTransformer) {
        JavaValueFilter filter = (JavaValueFilter)filterTransformer.apply(this.myFilter);
        if (filter == this.myFilter) {
            return this;
        }
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting, this.mySyntheticField, filter);
    }

    @NotNull
    SearchScope getSearchScope() {
        AnalysisScope scope = this.myParent.getScope();
        return this.myFilter.correctScope(scope.toSearchScope());
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder incrementNesting() {
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting + 1, this.mySyntheticField, this.myFilter.wrap());
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder decrementNesting() {
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting - 1, this.mySyntheticField, this.myFilter.unwrap());
    }

    boolean hasNesting() {
        return this.myIndexNesting > 0;
    }

    @Contract(pure=true)
    @NotNull
    SliceUsage getParent() {
        return this.myParent;
    }

    @Contract(pure=true)
    @NotNull
    PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    @Contract(pure=true)
    PsiType substitute(@Nullable PsiType type2) {
        return this.mySubstitutor.substitute(type2);
    }

    @Contract(pure=true)
    @NotNull
    String getSyntheticField() {
        return this.mySyntheticField;
    }

    @Contract(pure=true)
    @NotNull
    JavaValueFilter getFilter() {
        return this.myFilter;
    }

    @Contract(pure=true)
    @NotNull
    static JavaSliceBuilder create(@NotNull SliceUsage parent) {
        SliceValueFilter filter = parent.params.valueFilter;
        if (parent instanceof JavaSliceUsage) {
            JavaSliceUsage javaParent = (JavaSliceUsage)parent;
            return new JavaSliceBuilder(parent, javaParent.getSubstitutor(), javaParent.indexNesting, javaParent.syntheticField, filter);
        }
        return new JavaSliceBuilder(parent, PsiSubstitutor.EMPTY, 0, "", filter);
    }

    @Nullable
    JavaSliceBuilder combineSubstitutor(@NotNull PsiSubstitutor substitutor, @NotNull Project project) {
        PsiSubstitutor parentSubstitutor = this.mySubstitutor;
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)entry.getKey();
            PsiType type2 = (PsiType)entry.getValue();
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)type2);
            if (!parentSubstitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiType parentType = parentSubstitutor.substitute(parentSubstitutor.substitute(typeParameter));
            if (resolved instanceof PsiTypeParameter) {
                PsiTypeParameter res = (PsiTypeParameter)resolved;
                newMap.put(res, parentType);
                continue;
            }
            if (Comparing.equal((Object)type2, (Object)parentType)) continue;
            return null;
        }
        PsiSubstitutor combined = JavaPsiFacade.getElementFactory((Project)project).createSubstitutor((Map)newMap);
        return this.withSubstitutor(combined);
    }
}

