/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DfaBasedFilter {
    @Nullable
    private final DfaBasedFilter myNextFilter;
    @NotNull
    private final DfType myDfType;

    private DfaBasedFilter(@Nullable DfaBasedFilter nextFilter, @NotNull DfType type2) {
        this.myNextFilter = nextFilter;
        this.myDfType = type2;
    }

    DfaBasedFilter(@NotNull DfType type2) {
        this(null, type2);
    }

    @NotNull
    DfType getDfType() {
        return this.myDfType;
    }

    DfaBasedFilter wrap() {
        return new DfaBasedFilter(this, DfTypes.TOP);
    }

    DfaBasedFilter unwrap() {
        return this.myNextFilter;
    }

    boolean allowed(@NotNull PsiElement element) {
        return this.allowed(element, true);
    }

    boolean requiresAssertionViolation(@NotNull PsiElement element) {
        return this.allowed(element, true) && !this.allowed(element, false);
    }

    private boolean allowed(@NotNull PsiElement element, boolean assertionsDisabled) {
        DfConstantType dfConstantType;
        Object constValue;
        if (this.myDfType instanceof DfConstantType && element instanceof PsiLiteralValue && !((constValue = (dfConstantType = (DfConstantType)this.myDfType).getValue()) instanceof PsiElement)) {
            Object literalValue = ((PsiLiteralValue)element).getValue();
            Object value2 = constValue == null ? literalValue : TypeConversionUtil.computeCastTo((Object)literalValue, (PsiType)dfConstantType.getPsiType());
            return Objects.equals(value2, constValue);
        }
        DfType dfType = this.getElementDfType(element, assertionsDisabled);
        return dfType.meet(this.myDfType) != DfTypes.BOTTOM;
    }

    @Nullable
    DfaBasedFilter mergeFilter(@NotNull PsiElement element) {
        DfType meet;
        DfType type2 = this.getElementDfType(element, true);
        if (type2 instanceof DfReferenceType) {
            type2 = ((DfReferenceType)type2).dropLocality().dropMutability();
        }
        if ((meet = type2.meet(this.myDfType)) == DfTypes.TOP && this.myNextFilter == null) {
            return null;
        }
        if (meet == DfTypes.BOTTOM || meet.equals(this.myDfType)) {
            return this;
        }
        return new DfaBasedFilter(this.myNextFilter, meet);
    }

    @NotNull
    private DfType getElementDfType(@NotNull PsiElement element, boolean assertionsDisabled) {
        DfType type2;
        if (!(element instanceof PsiExpression)) {
            return DfTypes.TOP;
        }
        PsiExpression expression2 = (PsiExpression)element;
        PsiType expressionType = expression2.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType) && this.myDfType instanceof DfReferenceType) {
            return DfTypes.typedObject((PsiType)((PsiPrimitiveType)expressionType).getBoxedType((PsiElement)expression2), Nullability.NOT_NULL);
        }
        if (!(expressionType instanceof PsiPrimitiveType) && this.myDfType instanceof DfPrimitiveType) {
            return DfTypes.typedObject((PsiType)PsiPrimitiveType.getUnboxedType((PsiType)expressionType), Nullability.NOT_NULL);
        }
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        if (result == null) {
            return DfTypes.TOP;
        }
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        DfType dfType = type2 = assertionsDisabled ? result.getDfTypeNoAssertions(expression2) : result.getDfType(expression2);
        if (this.myDfType instanceof DfLongType && type2 instanceof DfIntType) {
            return DfTypes.longRange(((DfIntType)type2).getRange());
        }
        return type2;
    }

    @NotNull
    public String toString() {
        return this.myDfType.toString();
    }

    @NotNull
    @Nls
    public String getPresentationText(@NotNull PsiElement element) {
        if (element instanceof PsiLiteralExpression || element instanceof PsiExpression && JavaPsiMathUtil.getNumberFromLiteral((PsiExpression)element) != null) {
            return "";
        }
        if (element instanceof PsiNewExpression && ((PsiNewExpression)element).isArrayCreation()) {
            return "";
        }
        return DfaBasedFilter.getPresentationText(this.myDfType, DfaBasedFilter.getElementType(element));
    }

    @Nullable
    private static PsiType getElementType(@NotNull PsiElement element) {
        if (element instanceof PsiExpression) {
            return ((PsiExpression)element).getType();
        }
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        return null;
    }

    static String getPresentationText(@NotNull DfType type2, @Nullable PsiType psiType) {
        if (type2 == DfTypes.TOP) {
            return "";
        }
        if (type2 instanceof DfIntegralType) {
            LongRangeSet psiRange = LongRangeSet.fromType(psiType);
            LongRangeSet dfRange = ((DfIntegralType)type2).getRange();
            if (psiRange != null && dfRange.contains(psiRange)) {
                return "";
            }
            return dfRange.getPresentationText(psiType);
        }
        if (type2 instanceof DfConstantType) {
            return type2.toString();
        }
        if (type2 instanceof DfReferenceType) {
            DfReferenceType stripped = ((DfReferenceType)type2).dropNullability();
            DfaNullability nullability = ((DfReferenceType)type2).getNullability();
            TypeConstraint constraint = ((DfReferenceType)type2).getConstraint();
            if (constraint.getPresentationText(psiType).isEmpty()) {
                stripped = stripped.dropTypeConstraint();
            }
            String constraintText = stripped.toString();
            if (nullability == DfaNullability.NOT_NULL) {
                if (constraintText.isEmpty()) {
                    return "not-null";
                }
                return constraintText + " (not-null)";
            }
            if (nullability != DfaNullability.NULL) {
                if (constraintText.isEmpty()) {
                    return "";
                }
                return "null or " + constraintText;
            }
        }
        return type2.toString();
    }
}

