/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnalysisStartingPoint {
    final DfType myDfType;
    final PsiExpression myAnchor;

    AnalysisStartingPoint(DfType type2, PsiExpression anchor) {
        this.myDfType = type2;
        this.myAnchor = anchor;
    }

    @Nullable
    AnalysisStartingPoint tryMeet(@NotNull AnalysisStartingPoint next) {
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.myAnchor, next.myAnchor)) {
            return null;
        }
        DfType meet = this.myDfType.meet(next.myDfType);
        if (meet == DfTypes.BOTTOM) {
            return null;
        }
        return new AnalysisStartingPoint(meet, this.myAnchor);
    }

    @Nullable
    AnalysisStartingPoint tryJoin(@NotNull AnalysisStartingPoint next) {
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(this.myAnchor, next.myAnchor)) {
            return null;
        }
        DfType meet = this.myDfType.join(next.myDfType);
        if (meet == DfTypes.TOP) {
            return null;
        }
        return new AnalysisStartingPoint(meet, this.myAnchor);
    }

    @Nullable
    static AnalysisStartingPoint create(@NotNull DfType type2, @Nullable PsiExpression anchor) {
        if ((anchor = AnalysisStartingPoint.extractAnchor(anchor)) == null) {
            return null;
        }
        if (DfTypes.typedObject(anchor.getType(), Nullability.UNKNOWN).meet(type2) == DfTypes.BOTTOM) {
            return null;
        }
        return new AnalysisStartingPoint(type2, anchor);
    }

    @Nullable
    static PsiExpression extractAnchor(@Nullable PsiExpression target) {
        if ((target = PsiUtil.skipParenthesizedExprDown((PsiExpression)target)) instanceof PsiReferenceExpression || target instanceof PsiMethodCallExpression || target != null && AnalysisStartingPoint.propagateThroughExpression((PsiElement)target, DfTypes.LONG) != null) {
            return target;
        }
        return null;
    }

    @Nullable
    static AnalysisStartingPoint fromCondition(@Nullable PsiExpression cond) {
        PsiMethodCallExpression call;
        if ((cond = PsiUtil.skipParenthesizedExprDown((PsiExpression)cond)) == null) {
            return null;
        }
        if (cond instanceof PsiPolyadicExpression) {
            IElementType tokenType = ((PsiPolyadicExpression)cond).getOperationTokenType();
            if (tokenType.equals(JavaTokenType.ANDAND)) {
                AnalysisStartingPoint analysis = null;
                for (PsiExpression operand2 : ((PsiPolyadicExpression)cond).getOperands()) {
                    AnalysisStartingPoint next = AnalysisStartingPoint.fromCondition(operand2);
                    if (next == null) {
                        return null;
                    }
                    if (analysis == null) {
                        analysis = next;
                        continue;
                    }
                    if ((analysis = analysis.tryMeet(next)) != null) continue;
                    return null;
                }
                return analysis;
            }
            if (tokenType.equals(JavaTokenType.OROR)) {
                AnalysisStartingPoint analysis = null;
                for (PsiExpression operand3 : ((PsiPolyadicExpression)cond).getOperands()) {
                    AnalysisStartingPoint next = AnalysisStartingPoint.fromCondition(operand3);
                    if (next == null) {
                        return null;
                    }
                    if (analysis == null) {
                        analysis = next;
                        continue;
                    }
                    if ((analysis = analysis.tryJoin(next)) != null) continue;
                    return null;
                }
                return analysis;
            }
        }
        if (cond instanceof PsiBinaryExpression) {
            PsiBinaryExpression binop = (PsiBinaryExpression)cond;
            PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binop.getLOperand());
            PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binop.getROperand());
            AnalysisStartingPoint analysis = AnalysisStartingPoint.fromBinOp(left, binop.getOperationTokenType(), right);
            if (analysis != null) {
                return analysis;
            }
            return AnalysisStartingPoint.fromBinOp(right, binop.getOperationTokenType(), left);
        }
        if (cond instanceof PsiInstanceOfExpression) {
            PsiTypeElement checkType = ((PsiInstanceOfExpression)cond).getCheckType();
            if (checkType == null) {
                return null;
            }
            PsiExpression anchor = AnalysisStartingPoint.extractAnchor(((PsiInstanceOfExpression)cond).getOperand());
            if (anchor != null) {
                DfType typedObject = DfTypes.typedObject(checkType.getType(), Nullability.NOT_NULL);
                return new AnalysisStartingPoint(typedObject, anchor);
            }
        }
        if (cond instanceof PsiMethodCallExpression && MethodCallUtils.isEqualsCall(call = (PsiMethodCallExpression)cond)) {
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
            PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions())));
            if (qualifier != null && argument != null) {
                DfType type2 = AnalysisStartingPoint.fromConstant(qualifier);
                PsiExpression anchor = AnalysisStartingPoint.extractAnchor(argument);
                if (type2 == null) {
                    type2 = AnalysisStartingPoint.fromConstant(argument);
                    anchor = AnalysisStartingPoint.extractAnchor(qualifier);
                }
                if (type2 != null && anchor != null) {
                    PsiType anchorType = anchor.getType();
                    if (anchorType == null || DfTypes.typedObject(anchorType, Nullability.NOT_NULL).meet(type2) == DfTypes.BOTTOM) {
                        return null;
                    }
                    return new AnalysisStartingPoint(type2, anchor);
                }
            }
        }
        if (BoolUtils.isNegation(cond)) {
            AnalysisStartingPoint negatedAnalysis = AnalysisStartingPoint.fromCondition(BoolUtils.getNegated(cond));
            return AnalysisStartingPoint.tryNegate(negatedAnalysis);
        }
        PsiExpression anchor = AnalysisStartingPoint.extractAnchor(cond);
        if (anchor != null) {
            return new AnalysisStartingPoint(DfTypes.TRUE, anchor);
        }
        return null;
    }

    @Nullable
    static AnalysisStartingPoint tryNegate(AnalysisStartingPoint analysis) {
        if (analysis == null) {
            return null;
        }
        DfType type2 = analysis.myDfType.tryNegate();
        if (type2 == null) {
            return null;
        }
        NullabilityProblemKind.NullabilityProblem<?> problem = NullabilityProblemKind.fromContext(analysis.myAnchor, Collections.emptyMap());
        if (problem != null && "java.lang.NullPointerException".equals(problem.thrownException())) {
            type2 = type2.meet(DfTypes.NOT_NULL_OBJECT);
        }
        return new AnalysisStartingPoint(type2, analysis.myAnchor);
    }

    @Nullable
    static DfType fromConstant(@NotNull PsiExpression constant) {
        PsiElement target;
        if (constant instanceof PsiClassObjectAccessExpression) {
            PsiClassObjectAccessExpression classObject = (PsiClassObjectAccessExpression)constant;
            PsiTypeElement operand2 = classObject.getOperand();
            return DfTypes.constant(operand2.getType(), classObject.getType());
        }
        if (constant instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)constant).resolve()) instanceof PsiEnumConstant) {
            return DfTypes.constant(target, Objects.requireNonNull(constant.getType()));
        }
        if (ExpressionUtils.isNullLiteral(constant)) {
            return DfTypes.NULL;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(constant);
        if (value2 != null) {
            return DfTypes.constant(value2, Objects.requireNonNull(constant.getType()));
        }
        return null;
    }

    @Nullable
    private static AnalysisStartingPoint fromBinOp(@Nullable PsiExpression target, @NotNull IElementType type2, @Nullable PsiExpression constant) {
        RelationType relationType;
        if (constant == null) {
            return null;
        }
        DfType constantType = AnalysisStartingPoint.fromConstant(constant);
        if (constantType == null) {
            return null;
        }
        PsiExpression anchor = AnalysisStartingPoint.extractAnchor(target);
        if (anchor != null) {
            PsiType anchorType = anchor.getType();
            if (anchorType == null || TypeUtils.isJavaLangString(anchorType)) {
                return null;
            }
            if (anchorType.equals(PsiType.BYTE) || anchorType.equals(PsiType.CHAR) || anchorType.equals(PsiType.SHORT)) {
                anchorType = PsiType.INT;
            }
            if (constantType == DfTypes.NULL || DfTypes.typedObject(anchorType, Nullability.NOT_NULL).meet(constantType) != DfTypes.BOTTOM) {
                if (type2.equals(JavaTokenType.EQEQ)) {
                    return new AnalysisStartingPoint(constantType, anchor);
                }
                if (type2.equals(JavaTokenType.NE)) {
                    return AnalysisStartingPoint.tryNegate(new AnalysisStartingPoint(constantType, anchor));
                }
            }
        }
        if ((relationType = RelationType.fromElementType(type2)) != null) {
            LongRangeSet set = DfLongType.extractRange(constantType).fromRelation(relationType);
            if (anchor == null) {
                return null;
            }
            PsiType anchorType = anchor.getType();
            if (PsiType.LONG.equals((Object)anchorType)) {
                return new AnalysisStartingPoint(DfTypes.longRange(set), anchor);
            }
            if (PsiType.INT.equals((Object)anchorType) || PsiType.SHORT.equals((Object)anchorType) || PsiType.BYTE.equals((Object)anchorType) || PsiType.CHAR.equals((Object)anchorType)) {
                set = set.intersect(Objects.requireNonNull(LongRangeSet.fromType(anchorType)));
                return new AnalysisStartingPoint(DfTypes.intRangeClamped(set), anchor);
            }
        }
        return null;
    }

    static AnalysisStartingPoint propagateThroughExpression(@NotNull PsiElement expression2, @NotNull DfType origType) {
        AnalysisStartingPoint analysis = null;
        if (origType == DfTypes.TRUE) {
            analysis = AnalysisStartingPoint.fromCondition((PsiExpression)expression2);
        } else if (origType == DfTypes.FALSE) {
            analysis = AnalysisStartingPoint.tryNegate(AnalysisStartingPoint.fromCondition((PsiExpression)expression2));
        }
        DfIntegralType dfType = (DfIntegralType)ObjectUtils.tryCast((Object)origType, DfIntegralType.class);
        if (dfType != null) {
            boolean isLong = dfType instanceof DfLongType;
            LongRangeSet origRange = dfType.getRange();
            LongRangeSet newRange = null;
            PsiExpression anchor = null;
            if (expression2 instanceof PsiPrefixExpression) {
                anchor = ((PsiPrefixExpression)expression2).getOperand();
                IElementType type2 = ((PsiPrefixExpression)expression2).getOperationTokenType();
                if (type2.equals(JavaTokenType.MINUS)) {
                    newRange = origRange.negate(isLong);
                } else if (type2.equals(JavaTokenType.TILDE)) {
                    newRange = origRange.negate(isLong).minus(LongRangeSet.point(1L), isLong);
                }
            }
            if (expression2 instanceof PsiBinaryExpression) {
                Long right;
                PsiBinaryExpression binOp = (PsiBinaryExpression)expression2;
                IElementType type3 = binOp.getOperationTokenType();
                LongRangeSet leftRange = CommonDataflow.getExpressionRange(binOp.getLOperand());
                LongRangeSet rightRange = CommonDataflow.getExpressionRange(binOp.getROperand());
                Long left = leftRange == null ? null : leftRange.getConstantValue();
                Long l = right = rightRange == null ? null : rightRange.getConstantValue();
                if (type3.equals(JavaTokenType.PERC) && right != null) {
                    newRange = LongRangeSet.fromRemainder(right, origRange);
                    anchor = binOp.getLOperand();
                }
                if (type3.equals(JavaTokenType.PLUS)) {
                    if (right != null) {
                        newRange = origRange.minus(LongRangeSet.point(right), isLong);
                        anchor = binOp.getLOperand();
                    } else if (left != null) {
                        newRange = origRange.minus(LongRangeSet.point(left), isLong);
                        anchor = binOp.getROperand();
                    }
                }
                if (type3.equals(JavaTokenType.MINUS)) {
                    if (right != null) {
                        newRange = origRange.plus(LongRangeSet.point(right), isLong);
                        anchor = binOp.getLOperand();
                    } else if (left != null) {
                        newRange = LongRangeSet.point(left).minus(origRange, isLong);
                        anchor = binOp.getROperand();
                    }
                }
            }
            if (newRange != null && anchor != null && !(anchor instanceof PsiLiteralExpression)) {
                analysis = new AnalysisStartingPoint(isLong ? DfTypes.longRange(newRange) : DfTypes.intRangeClamped(newRange), anchor);
            }
        }
        return analysis;
    }
}

