/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class UnwrapCall
extends FixableUsageInfo {
    private final String myUnwrapMethod;

    public UnwrapCall(@NotNull PsiExpression call, @NotNull String unwrapMethod) {
        super((PsiElement)call);
        this.myUnwrapMethod = unwrapMethod;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiElement element = this.getElement();
        if (!(element instanceof PsiExpression)) {
            return;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiExpression expression2 = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)element);
            if (expression2 == null) {
                return;
            }
            element = expression2;
        }
        String newExpression = element.getText() + '.' + this.myUnwrapMethod + "()";
        MutationUtils.replaceExpression(newExpression, (PsiExpression)element);
    }
}

