/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableReturnValue
implements ReturnValue {
    private final PsiVariable myVariable;

    public VariableReturnValue(PsiVariable variable) {
        this.myVariable = variable;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof VariableReturnValue)) {
            return false;
        }
        return this.myVariable == ((VariableReturnValue)other).myVariable;
    }

    public PsiVariable getVariable() {
        return this.myVariable;
    }

    @Override
    @Nullable
    public PsiStatement createReplacement(@NotNull PsiMethod extractedMethod, @NotNull PsiMethodCallExpression methodCallExpression, @Nullable PsiType returnType) throws IncorrectOperationException {
        Project project = methodCallExpression.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
        JavaCodeStyleManager javaStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        PsiType type2 = returnType != null && returnType.isValid() ? returnType : this.myVariable.getType();
        PsiDeclarationStatement statement = (PsiDeclarationStatement)styleManager.reformat(javaStyleManager.shortenClassReferences((PsiElement)elementFactory.createVariableDeclarationStatement(this.myVariable.getName(), type2, (PsiExpression)methodCallExpression)));
        ((PsiVariable)statement.getDeclaredElements()[0]).getModifierList().replace((PsiElement)this.myVariable.getModifierList());
        return statement;
    }
}

