/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineUtil {
    private static final Logger LOG = Logger.getInstance(InlineUtil.class);

    private InlineUtil() {
    }

    @NotNull
    public static PsiExpression inlineVariable(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref) throws IncorrectOperationException {
        return InlineUtil.inlineVariable(variable, initializer, ref, null);
    }

    @NotNull
    public static PsiExpression inlineVariable(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref, PsiExpression thisAccessExpr) throws IncorrectOperationException {
        PsiType exprType;
        PsiType type2;
        IElementType operationTokenType;
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiResourceExpression) {
            LOG.error("Unable to inline resource reference");
            return (PsiExpression)ref;
        }
        PsiManager manager = initializer.getManager();
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)initializer);
        PsiClass refParent = RefactoringChangeUtil.getThisClass((PsiElement)ref);
        PsiType varType = variable.getType();
        if ((initializer = RefactoringUtil.convertInitializerToNormalExpression(initializer, varType)) instanceof PsiPolyadicExpression && ((operationTokenType = ((PsiPolyadicExpression)initializer).getOperationTokenType()) == JavaTokenType.PLUS || operationTokenType == JavaTokenType.MINUS) && parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType() == JavaTokenType.PLUS && (type2 = ((PsiPolyadicExpression)parent).getType()) != null && type2.equalsToText("java.lang.String")) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)initializer.getProject());
            initializer = factory.createExpressionFromText("(" + initializer.getText() + ")", (PsiElement)initializer);
        }
        InlineUtil.solveVariableNameConflicts((PsiElement)initializer, (PsiElement)ref, (PsiElement)initializer);
        ChangeContextUtil.encodeContextInfo((PsiElement)initializer, false);
        PsiExpression expr2 = (PsiExpression)InlineUtil.replaceDiamondWithInferredTypesIfNeeded(initializer, (PsiElement)ref);
        if (thisAccessExpr == null) {
            thisAccessExpr = InlineUtil.createThisExpression(manager, thisClass, refParent);
        }
        if ((exprType = RefactoringUtil.getTypeByExpression(expr2 = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)expr2, thisClass, thisAccessExpr))) != null && !exprType.equals(varType)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
            PsiMethod method = InlineUtil.qualifyWithExplicitTypeArguments(initializer, expr2, varType);
            if (method != null) {
                PsiReferenceExpression methodExpression;
                PsiExpression qualifierExpression2;
                if (expr2 instanceof PsiMethodCallExpression && (qualifierExpression2 = (methodExpression = ((PsiMethodCallExpression)expr2).getMethodExpression()).getQualifierExpression()) == null) {
                    PsiClass containingClass = method.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    if (method.getModifierList().hasModifierProperty("static")) {
                        methodExpression.setQualifierExpression((PsiExpression)elementFactory.createReferenceExpression(containingClass));
                    } else {
                        methodExpression.setQualifierExpression((PsiExpression)InlineUtil.createThisExpression(method.getManager(), thisClass, refParent));
                    }
                }
            } else if (varType instanceof PsiEllipsisType && ((PsiEllipsisType)varType).getComponentType().equals(exprType)) {
                PsiExpressionList argumentList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiExpressionList.class);
                LOG.assertTrue(argumentList != null);
                PsiExpression[] arguments = argumentList.getExpressions();
                String varargsWrapper = "new " + exprType.getCanonicalText() + "[]{" + StringUtil.join(Arrays.asList(arguments), PsiElement::getText, (String)",") + '}';
                expr2.replace((PsiElement)elementFactory.createExpressionFromText(varargsWrapper, (PsiElement)argumentList));
            } else {
                boolean insertCastWhenUnchecked;
                boolean bl = insertCastWhenUnchecked = !(exprType instanceof PsiClassType) || !((PsiClassType)exprType).isRaw() || !(parent instanceof PsiExpressionList);
                if (expr2 instanceof PsiFunctionalExpression || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expr2) && insertCastWhenUnchecked) {
                    expr2 = InlineUtil.surroundWithCast(variable, expr2);
                }
            }
        }
        ChangeContextUtil.clearContextInfo((PsiElement)initializer);
        return expr2;
    }

    private static PsiMethod qualifyWithExplicitTypeArguments(PsiExpression initializer, PsiExpression expr2, PsiType varType) {
        PsiTypeParameter[] typeParameters;
        JavaResolveResult resolveResult;
        PsiElement resolved;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)initializer.getProject());
        if (expr2 instanceof PsiCallExpression && ((PsiCallExpression)expr2).getTypeArguments().length == 0 && (resolved = (resolveResult = ((PsiCallExpression)initializer).resolveMethodGenerics()).getElement()) instanceof PsiMethod && (typeParameters = ((PsiMethod)resolved).getTypeParameters()).length > 0) {
            PsiCallExpression copy = (PsiCallExpression)expr2.copy();
            for (PsiTypeParameter typeParameter : typeParameters) {
                PsiType substituted = resolveResult.getSubstitutor().substitute(typeParameter);
                if (substituted == null) break;
                copy.getTypeArgumentList().add((PsiElement)elementFactory.createTypeElement(substituted));
            }
            if (varType.equals(copy.getType()) && copy.resolveMethodGenerics().isValidResult()) {
                ((PsiCallExpression)expr2).getTypeArgumentList().replace((PsiElement)copy.getTypeArgumentList());
                return (PsiMethod)resolved;
            }
        }
        return null;
    }

    private static PsiExpression surroundWithCast(PsiVariable variable, PsiExpression expr2) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr2.getProject());
        PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(t)a", null);
        PsiTypeElement castTypeElement = cast.getCastType();
        assert (castTypeElement != null);
        PsiTypeElement typeElement = variable.getTypeElement();
        if (typeElement == null) {
            typeElement = factory.createTypeElement(variable.getType());
        } else if (typeElement.isInferredType()) {
            return expr2;
        }
        castTypeElement.replace((PsiElement)typeElement);
        PsiExpression operand2 = cast.getOperand();
        assert (operand2 != null);
        operand2.replace((PsiElement)expr2);
        expr2 = (PsiTypeCastExpression)expr2.replace((PsiElement)cast);
        if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)expr2)) {
            return RemoveRedundantCastUtil.removeCast((PsiTypeCastExpression)expr2);
        }
        return expr2;
    }

    private static PsiThisExpression createThisExpression(PsiManager manager, PsiClass thisClass, PsiClass refParent) {
        PsiThisExpression thisAccessExpr = null;
        if (Comparing.equal((Object)thisClass, (Object)refParent)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression(manager, null);
        } else if (!(thisClass instanceof PsiAnonymousClass)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression(manager, thisClass);
        }
        return thisAccessExpr;
    }

    public static void tryToInlineArrayCreationForVarargs(PsiExpression expr2) {
        PsiExpressionList exprList;
        if (expr2 instanceof PsiNewExpression && ((PsiNewExpression)expr2).getArrayInitializer() != null && expr2.getParent() instanceof PsiExpressionList && (exprList = (PsiExpressionList)expr2.getParent()).getParent() instanceof PsiCall && InlineUtil.isSafeToInlineVarargsArgument((PsiCall)exprList.getParent())) {
            InlineUtil.inlineArrayCreationForVarargs((PsiNewExpression)expr2);
        }
    }

    public static void inlineArrayCreationForVarargs(PsiNewExpression arrayCreation) {
        PsiExpressionList argumentList = (PsiExpressionList)PsiUtil.skipParenthesizedExprUp((PsiElement)arrayCreation.getParent());
        if (argumentList == null) {
            return;
        }
        PsiExpression[] args = argumentList.getExpressions();
        PsiArrayInitializerExpression arrayInitializer = arrayCreation.getArrayInitializer();
        try {
            if (arrayInitializer == null) {
                arrayCreation.delete();
                return;
            }
            CommentTracker cm = new CommentTracker();
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            if (initializers.length > 0) {
                PsiElement nextSibling;
                PsiExpression lastInitializerSibling = initializers[initializers.length - 1];
                while ((nextSibling = lastInitializerSibling.getNextSibling()) != null && !PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.RBRACE)) {
                    lastInitializerSibling = nextSibling;
                }
                if (lastInitializerSibling instanceof PsiWhiteSpace) {
                    lastInitializerSibling = lastInitializerSibling.getPrevSibling();
                }
                if (lastInitializerSibling instanceof PsiComment) {
                    PsiElement possibleComma = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastInitializerSibling);
                    if (PsiUtil.isJavaToken((PsiElement)possibleComma, (IElementType)JavaTokenType.COMMA)) {
                        possibleComma.delete();
                    }
                } else if (PsiUtil.isJavaToken((PsiElement)lastInitializerSibling, (IElementType)JavaTokenType.COMMA)) {
                    lastInitializerSibling = lastInitializerSibling.getPrevSibling();
                }
                PsiExpression firstElement = initializers[0];
                PsiElement leadingComment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)firstElement);
                if (leadingComment instanceof PsiComment) {
                    firstElement = leadingComment;
                }
                argumentList.addRange((PsiElement)firstElement, (PsiElement)lastInitializerSibling);
                cm.markRangeUnchanged((PsiElement)firstElement, (PsiElement)lastInitializerSibling);
            }
            cm.deleteAndRestoreComments((PsiElement)args[args.length - 1]);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static boolean isSafeToInlineVarargsArgument(PsiCall expression2) {
        JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
        PsiElement element = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (element instanceof PsiMethod && ((PsiMethod)element).isVarArgs()) {
            PsiExpression[] args;
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList != null && parameters2.length == (args = argumentList.getExpressions()).length) {
                PsiType lastArgType;
                PsiExpression lastArg = args[args.length - 1];
                PsiParameter lastParameter = parameters2[args.length - 1];
                PsiType lastParamType = lastParameter.getType();
                LOG.assertTrue(lastParamType instanceof PsiEllipsisType);
                if (lastArg instanceof PsiNewExpression && (lastArgType = lastArg.getType()) != null && substitutor.substitute(((PsiEllipsisType)lastParamType).toArrayType()).isAssignableFrom(lastArgType)) {
                    PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)lastArg).getArrayInitializer();
                    PsiExpression[] initializers = arrayInitializer != null ? arrayInitializer.getInitializers() : PsiExpression.EMPTY_ARRAY;
                    return InlineUtil.isSafeToFlatten(expression2, method, initializers);
                }
            }
        }
        return false;
    }

    private static boolean isSafeToFlatten(PsiCall callExpression, PsiMethod oldRefMethod, PsiExpression[] arrayElements) {
        for (PsiExpression arrayElement : arrayElements) {
            if (!(arrayElement instanceof PsiArrayInitializerExpression)) continue;
            return false;
        }
        PsiCall copy = (PsiCall)callExpression.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        LOG.assertTrue(copyArgumentList != null);
        PsiExpression[] args = copyArgumentList.getExpressions();
        try {
            args[args.length - 1].delete();
            if (arrayElements.length > 0) {
                copyArgumentList.addRange((PsiElement)arrayElements[0], (PsiElement)arrayElements[arrayElements.length - 1]);
            }
            return copy.resolveMethod() == oldRefMethod;
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public static boolean allUsagesAreTailCalls(PsiMethod method) {
        List nonTailCallUsages = Collections.synchronizedList(new ArrayList());
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReferencesSearch.search((PsiElement)method).forEach(psiReference -> {
            ProgressManager.checkCanceled();
            if (InlineUtil.getTailCallType(psiReference) == TailCallType.None) {
                nonTailCallUsages.add(psiReference);
                return false;
            }
            return true;
        }), JavaRefactoringBundle.message((String)"inline.method.checking.tail.calls.progress", (Object[])new Object[0]), true, method.getProject());
        return result && nonTailCallUsages.isEmpty();
    }

    public static TailCallType getTailCallType(@NotNull PsiReference psiReference) {
        PsiElement negationParent;
        PsiElement element = psiReference.getElement();
        if (element instanceof PsiMethodReferenceExpression) {
            return TailCallType.Return;
        }
        PsiExpression methodCall = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (methodCall == null) {
            return TailCallType.None;
        }
        PsiElement callParent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        if (callParent instanceof PsiReturnStatement || callParent instanceof PsiLambdaExpression) {
            return TailCallType.Return;
        }
        if (callParent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)callParent) && ((negationParent = PsiUtil.skipParenthesizedExprUp((PsiElement)callParent.getParent())) instanceof PsiReturnStatement || negationParent instanceof PsiLambdaExpression)) {
            return TailCallType.Invert;
        }
        if (callParent instanceof PsiExpressionStatement) {
            PsiStatement curElement = (PsiStatement)callParent;
            while (true) {
                if (PsiTreeUtil.getNextSiblingOfType((PsiElement)curElement, PsiStatement.class) != null) {
                    return TailCallType.None;
                }
                PsiElement parent = curElement.getParent();
                if (parent instanceof PsiCodeBlock) {
                    PsiElement blockParent = parent.getParent();
                    if (blockParent instanceof PsiMethod || blockParent instanceof PsiLambdaExpression) {
                        return TailCallType.Simple;
                    }
                    if (!(blockParent instanceof PsiBlockStatement)) {
                        return TailCallType.None;
                    }
                    parent = blockParent.getParent();
                    if (parent instanceof PsiLoopStatement) {
                        return TailCallType.Continue;
                    }
                }
                if (!(parent instanceof PsiLabeledStatement) && !(parent instanceof PsiIfStatement)) {
                    return TailCallType.None;
                }
                curElement = (PsiStatement)parent;
            }
        }
        return TailCallType.None;
    }

    public static void substituteTypeParams(PsiElement scope, final PsiSubstitutor substitutor, final PsiElementFactory factory) {
        final HashMap replacement = new HashMap();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitTypeElement(PsiTypeElement typeElement) {
                PsiClassType.ClassResolveResult resolveResult;
                PsiElement resolved;
                super.visitTypeElement(typeElement);
                PsiType type2 = typeElement.getType();
                if (type2 instanceof PsiClassType && (resolved = (resolveResult = ((PsiClassType)type2).resolveGenerics()).getElement()) instanceof PsiTypeParameter) {
                    PsiType newType = resolveResult.getSubstitutor().putAll(substitutor).substitute((PsiTypeParameter)resolved);
                    if (newType instanceof PsiCapturedWildcardType) {
                        newType = ((PsiCapturedWildcardType)newType).getUpperBound();
                    }
                    if (newType instanceof PsiWildcardType) {
                        newType = ((PsiWildcardType)newType).getBound();
                    }
                    if (newType == null) {
                        newType = PsiType.getJavaLangObject((PsiManager)resolved.getManager(), (GlobalSearchScope)resolved.getResolveScope());
                    }
                    try {
                        replacement.put(typeElement, factory.createTypeElement(newType));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        for (PsiElement element : replacement.keySet()) {
            if (!element.isValid()) continue;
            element.replace((PsiElement)replacement.get(element));
        }
    }

    private static PsiElement replaceDiamondWithInferredTypesIfNeeded(PsiExpression initializer, PsiElement ref) {
        PsiDiamondType.DiamondInferenceResult inferenceResult;
        PsiDiamondType diamondType;
        if (initializer instanceof PsiNewExpression && (diamondType = PsiDiamondType.getDiamondType((PsiNewExpression)((PsiNewExpression)initializer))) != null && (inferenceResult = diamondType.resolveInferredTypes()).getErrorMessage() == null) {
            PsiElement copy = ref.copy();
            PsiElement parent = ref.replace((PsiElement)initializer);
            PsiDiamondType.DiamondInferenceResult result = PsiDiamondTypeImpl.resolveInferredTypes((PsiNewExpression)initializer, parent);
            ref = parent.replace(copy);
            if (!result.equals((Object)inferenceResult)) {
                String inferredTypeText = StringUtil.join((Object[])inferenceResult.getTypes(), psiType -> psiType.getCanonicalText(), (String)", ");
                PsiJavaCodeReferenceElement classReference2 = ((PsiNewExpression)initializer).getClassOrAnonymousClassReference();
                PsiNewExpression expandedDiamond = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createExpressionFromText("new " + Objects.requireNonNull(classReference2).getReferenceName() + "<" + inferredTypeText + ">()", (PsiElement)initializer);
                PsiNewExpression newExpression = (PsiNewExpression)initializer.copy();
                Objects.requireNonNull(newExpression.getClassOrAnonymousClassReference()).replace((PsiElement)Objects.requireNonNull(expandedDiamond.getClassReference()));
                return ref.replace((PsiElement)newExpression);
            }
        }
        return ref != initializer ? ref.replace((PsiElement)initializer) : initializer;
    }

    public static void solveVariableNameConflicts(PsiElement scope, PsiElement placeToInsert, PsiElement renameScope) throws IncorrectOperationException {
        PsiElement[] children;
        if (scope instanceof PsiVariable) {
            String newName;
            String name2;
            PsiVariable var = (PsiVariable)scope;
            String oldName = name2 = var.getName();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)scope.getProject());
            while (!(newName = codeStyleManager.suggestUniqueVariableName(name2, placeToInsert, true)).equals(name2) && !(newName = codeStyleManager.suggestUniqueVariableName(name2 = newName, (PsiElement)var, true)).equals(name2)) {
                name2 = newName;
            }
            if (!name2.equals(oldName)) {
                RefactoringUtil.renameVariableReferences(var, name2, (SearchScope)new LocalSearchScope(renameScope), true);
                var.getNameIdentifier().replace((PsiElement)JavaPsiFacade.getElementFactory((Project)scope.getProject()).createIdentifier(name2));
            }
        }
        for (PsiElement child : children = scope.getChildren()) {
            InlineUtil.solveVariableNameConflicts(child, placeToInsert, renameScope);
        }
    }

    public static boolean isChainingConstructor(PsiMethod constructor) {
        return RefactoringUtil.getChainedConstructor(constructor) != null;
    }

    public static void checkChangedBeforeLastAccessConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull PsiExpression initializer, @NotNull PsiVariable variable) {
        Set<PsiVariable> referencedVars = VariableAccessUtils.collectUsedVariables((PsiElement)initializer);
        if (referencedVars.isEmpty()) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)initializer, null);
        if (scope == null) {
            return;
        }
        ControlFlow flow = InlineUtil.createControlFlow(scope);
        if (flow == null) {
            return;
        }
        int start = flow.getEndOffset((PsiElement)initializer);
        if (start < 0) {
            return;
        }
        Map<PsiElement, PsiVariable> writePlaces = ControlFlowUtil.getWritesBeforeReads(flow, referencedVars, Collections.singleton(variable), start);
        String readVarName = variable.getName();
        for (Map.Entry<PsiElement, PsiVariable> writePlaceEntry : writePlaces.entrySet()) {
            String message2 = JavaRefactoringBundle.message((String)"variable.0.is.changed.before.last.access", (Object[])new Object[]{writePlaceEntry.getValue().getName(), readVarName});
            conflicts.putValue((Object)writePlaceEntry.getKey(), (Object)message2);
        }
    }

    @Nullable
    private static ControlFlow createControlFlow(@NotNull PsiElement scope) {
        ControlFlowFactory factory = ControlFlowFactory.getInstance(scope.getProject());
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        try {
            return factory.getControlFlow(scope, policy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    public static void extractReturnValues(PsiMethod method, boolean replaceWithContinue) {
        PsiReturnStatement[] returnStatements;
        PsiCodeBlock block = Objects.requireNonNull(method.getBody());
        for (PsiReturnStatement returnStatement : returnStatements = PsiUtil.findReturnStatements((PsiMethod)method)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue != null) {
                List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(returnValue);
                CommentTracker ct = new CommentTracker();
                sideEffects.forEach(ct::markUnchanged);
                PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, returnValue);
                ct.delete((PsiElement)returnValue);
                if (statements.length > 0) {
                    PsiStatement lastAdded = BlockUtils.addBefore((PsiStatement)returnStatement, statements);
                    returnStatement = (PsiReturnStatement)Objects.requireNonNull(PsiTreeUtil.getNextSiblingOfType((PsiElement)lastAdded, PsiReturnStatement.class));
                }
                ct.insertCommentsBefore((PsiElement)returnStatement);
            }
            if (ControlFlowUtils.blockCompletesWithStatement(block, (PsiStatement)returnStatement)) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)returnStatement);
                continue;
            }
            if (!replaceWithContinue) continue;
            new CommentTracker().replaceAndRestoreComments((PsiElement)returnStatement, "continue;");
        }
    }

    public static PsiExpression inlineInitializer(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref) {
        SimplifyBooleanExpressionFix fix;
        Boolean value2;
        PsiClass varThisClass;
        Project project = variable.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        if (initializer instanceof PsiThisExpression && ((PsiThisExpression)initializer).getQualifier() == null && (varThisClass = RefactoringChangeUtil.getThisClass((PsiElement)variable)) != null && varThisClass != RefactoringChangeUtil.getThisClass((PsiElement)ref)) {
            initializer = factory.createExpressionFromText(varThisClass.getName() + ".this", (PsiElement)variable);
        }
        PsiExpression expr2 = InlineUtil.inlineVariable(variable, initializer, ref);
        InlineUtil.tryToInlineArrayCreationForVarargs(expr2);
        if (expr2 instanceof PsiThisExpression && expr2.getParent() instanceof PsiReferenceExpression) {
            PsiElement newRefElement;
            PsiReferenceExpression refExpr = (PsiReferenceExpression)expr2.getParent();
            PsiElement refElement = refExpr.resolve();
            PsiExpression exprCopy = (PsiExpression)refExpr.copy();
            refExpr = (PsiReferenceExpression)refExpr.replace((PsiElement)factory.createExpressionFromText(Objects.requireNonNull(refExpr.getReferenceName()), null));
            if (refElement != null && !refElement.equals(newRefElement = refExpr.resolve())) {
                refExpr.replace((PsiElement)exprCopy);
            }
        }
        if (expr2 instanceof PsiLiteralExpression && PsiType.BOOLEAN.equals((Object)expr2.getType()) && (value2 = (Boolean)ObjectUtils.tryCast((Object)((PsiLiteralExpression)expr2).getValue(), Boolean.class)) != null && (fix = new SimplifyBooleanExpressionFix(expr2, value2)).isAvailable()) {
            fix.invoke(project, expr2.getContainingFile(), (PsiElement)expr2, (PsiElement)expr2);
        }
        return initializer;
    }

    public static boolean canInlineParameterOrThisVariable(PsiLocalVariable variable) {
        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (block == null) {
            return false;
        }
        List<PsiReferenceExpression> refs = VariableAccessUtils.getVariableReferences((PsiVariable)variable, block);
        boolean isAccessedForWriting = false;
        for (PsiReferenceExpression refElement : refs) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)refElement)) continue;
            isAccessedForWriting = true;
        }
        PsiExpression initializer = variable.getInitializer();
        return InlineUtil.canInlineParameterOrThisVariable(variable.getProject(), initializer, false, false, refs.size(), isAccessedForWriting);
    }

    private static boolean canInlineParameterOrThisVariable(Project project, PsiExpression initializer, boolean shouldBeFinal, boolean strictlyFinal, int accessCount, boolean isAccessedForWriting) {
        if (strictlyFinal) {
            class CanAllLocalsBeDeclaredFinal
            extends JavaRecursiveElementWalkingVisitor {
                private boolean success = true;

                CanAllLocalsBeDeclaredFinal() {
                }

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    PsiElement psiElement = expression2.resolve();
                    if ((psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter) && !RefactoringUtil.canBeDeclaredFinal((PsiVariable)psiElement)) {
                        this.success = false;
                    }
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (this.success) {
                        super.visitElement(element);
                    }
                }
            }
            CanAllLocalsBeDeclaredFinal canAllLocalsBeDeclaredFinal = new CanAllLocalsBeDeclaredFinal();
            initializer.accept((PsiElementVisitor)canAllLocalsBeDeclaredFinal);
            if (!canAllLocalsBeDeclaredFinal.success) {
                return false;
            }
        }
        if (initializer instanceof PsiFunctionalExpression) {
            return accessCount <= 1;
        }
        if (initializer instanceof PsiReferenceExpression) {
            PsiVariable refVar = (PsiVariable)((PsiReferenceExpression)initializer).resolve();
            if (refVar == null) {
                return !isAccessedForWriting;
            }
            if (refVar instanceof PsiField) {
                if (isAccessedForWriting) {
                    return false;
                }
                if (refVar.hasModifierProperty("volatile")) {
                    return accessCount <= 1;
                }
                return true;
            }
            if (isAccessedForWriting) {
                if (refVar.hasModifierProperty("final") || shouldBeFinal) {
                    return false;
                }
                PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)refVar, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
                return refs.length == 1;
            }
            if (shouldBeFinal) {
                return refVar.hasModifierProperty("final") || RefactoringUtil.canBeDeclaredFinal(refVar);
            }
            return true;
        }
        if (isAccessedForWriting) {
            return false;
        }
        if (initializer instanceof PsiCallExpression) {
            PsiExpression[] expressions2;
            PsiArrayInitializerExpression arrayInitializer;
            if (accessCount != 1) {
                return false;
            }
            if (initializer instanceof PsiNewExpression && (arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer()) != null) {
                for (PsiExpression expression2 : arrayInitializer.getInitializers()) {
                    if (InlineUtil.canInlineParameterOrThisVariable(project, expression2, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                    return false;
                }
                return true;
            }
            PsiExpressionList argumentList = ((PsiCallExpression)initializer).getArgumentList();
            if (argumentList == null) {
                return false;
            }
            for (PsiExpression expression3 : expressions2 = argumentList.getExpressions()) {
                if (InlineUtil.canInlineParameterOrThisVariable(project, expression3, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                return false;
            }
            return true;
        }
        if (initializer instanceof PsiLiteralExpression) {
            return true;
        }
        if (initializer instanceof PsiPrefixExpression && ((PsiPrefixExpression)initializer).getOperand() instanceof PsiLiteralExpression) {
            return true;
        }
        if (initializer instanceof PsiArrayAccessExpression) {
            PsiExpression arrayExpression = ((PsiArrayAccessExpression)initializer).getArrayExpression();
            PsiExpression indexExpression = ((PsiArrayAccessExpression)initializer).getIndexExpression();
            return InlineUtil.canInlineParameterOrThisVariable(project, arrayExpression, shouldBeFinal, strictlyFinal, accessCount, false) && InlineUtil.canInlineParameterOrThisVariable(project, indexExpression, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiParenthesizedExpression) {
            PsiExpression expr2 = ((PsiParenthesizedExpression)initializer).getExpression();
            return expr2 == null || InlineUtil.canInlineParameterOrThisVariable(project, expr2, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiTypeCastExpression) {
            PsiExpression operand2 = ((PsiTypeCastExpression)initializer).getOperand();
            return operand2 != null && InlineUtil.canInlineParameterOrThisVariable(project, operand2, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression binExpr = (PsiPolyadicExpression)initializer;
            for (PsiExpression op : binExpr.getOperands()) {
                if (InlineUtil.canInlineParameterOrThisVariable(project, op, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                return false;
            }
            return true;
        }
        if (initializer instanceof PsiClassObjectAccessExpression) {
            return true;
        }
        if (initializer instanceof PsiThisExpression) {
            return true;
        }
        return initializer instanceof PsiSuperExpression;
    }

    /*
     * WARNING - void declaration
     */
    public static void tryInlineGeneratedLocal(PsiLocalVariable variable, boolean strictlyFinal) throws IncorrectOperationException {
        PsiElement scope = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        if (scope == null) {
            return;
        }
        List<PsiReferenceExpression> refs = VariableAccessUtils.getVariableReferences((PsiVariable)variable, scope);
        PsiReferenceExpression firstRef = (PsiReferenceExpression)ContainerUtil.getFirstItem(refs);
        PsiExpression initializer = variable.getInitializer();
        if (firstRef == null) {
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)variable.getParent();
            if (initializer != null) {
                void var10_16;
                List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(initializer);
                PsiStatement[] psiStatementArray = StatementExtractor.generateStatements(sideEffects, initializer);
                int n = psiStatementArray.length;
                boolean bl = false;
                while (var10_16 < n) {
                    PsiStatement statement = psiStatementArray[var10_16];
                    declaration2.getParent().addBefore((PsiElement)statement, (PsiElement)declaration2);
                    ++var10_16;
                }
            }
            declaration2.delete();
            return;
        }
        boolean isAccessedForWriting = false;
        for (PsiReferenceExpression refElement : refs) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)refElement)) continue;
            isAccessedForWriting = true;
        }
        boolean shouldBeFinal = variable.hasModifierProperty("final") && strictlyFinal;
        Project project = variable.getProject();
        if (InlineUtil.canInlineParameterOrThisVariable(project, initializer, shouldBeFinal, strictlyFinal, refs.size(), isAccessedForWriting)) {
            if (shouldBeFinal) {
                InlineUtil.declareUsedLocalsFinal((PsiElement)initializer, true);
            }
            for (PsiReference psiReference : refs) {
                initializer = InlineUtil.inlineInitializer((PsiVariable)variable, initializer, (PsiJavaCodeReferenceElement)psiReference);
            }
            variable.getParent().delete();
        }
    }

    private static void declareUsedLocalsFinal(PsiElement expr2, boolean strictlyFinal) throws IncorrectOperationException {
        PsiElement[] children;
        PsiElement refElement;
        if (expr2 instanceof PsiReferenceExpression && ((refElement = ((PsiReferenceExpression)expr2).resolve()) instanceof PsiLocalVariable || refElement instanceof PsiParameter) && (strictlyFinal || RefactoringUtil.canBeDeclaredFinal((PsiVariable)refElement))) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiVariable)refElement), (String)"final", (boolean)true);
        }
        for (PsiElement child : children = expr2.getChildren()) {
            InlineUtil.declareUsedLocalsFinal(child, strictlyFinal);
        }
    }

    public static void tryInlineResultVariable(@NotNull PsiLocalVariable resultVar, @NotNull PsiReferenceExpression resultUsage) throws IncorrectOperationException {
        PsiElement context = PsiUtil.getVariableCodeBlock((PsiVariable)resultVar, null);
        if (context == null) {
            return;
        }
        List<PsiReferenceExpression> references = VariableAccessUtils.getVariableReferences((PsiVariable)resultVar, context);
        if (resultVar.getInitializer() == null) {
            PsiAssignmentExpression assignment = null;
            for (PsiReferenceExpression ref : references) {
                if (!(ref.getParent() instanceof PsiAssignmentExpression) || !((PsiAssignmentExpression)ref.getParent()).getLExpression().equals(ref)) continue;
                if (assignment != null) {
                    assignment = null;
                    break;
                }
                assignment = (PsiAssignmentExpression)ref.getParent();
            }
            if (assignment != null) {
                InlineUtil.inlineSingleAssignment((PsiVariable)resultVar, assignment, resultUsage);
                return;
            }
        }
        InlineUtil.tryReplaceWithTarget(resultVar, resultUsage, context, references);
    }

    private static void tryReplaceWithTarget(@NotNull PsiLocalVariable variable, @NotNull PsiReferenceExpression usage, PsiElement context, List<? extends PsiReferenceExpression> references) {
        PsiModifierList modifierList;
        PsiLocalVariable target = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)usage.getParent()), PsiLocalVariable.class);
        if (target == null) {
            return;
        }
        String name2 = target.getName();
        if (!target.getType().equals(variable.getType())) {
            return;
        }
        PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)target.getParent(), PsiDeclarationStatement.class);
        if (declaration2 == null || declaration2.getDeclaredElements().length != 1) {
            return;
        }
        PsiModifierList modifiers = target.getModifierList();
        if (modifiers != null && modifiers.getAnnotations().length != 0) {
            return;
        }
        boolean effectivelyFinal = HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, context, null);
        if (!effectivelyFinal && !VariableAccessUtils.canUseAsNonFinal(target)) {
            return;
        }
        for (PsiReferenceExpression psiReferenceExpression : references) {
            ExpressionUtils.bindReferenceTo(psiReferenceExpression, name2);
        }
        if (effectivelyFinal && target.hasModifierProperty("final") && (modifierList = variable.getModifierList()) != null) {
            modifierList.setModifierProperty("final", true);
        }
        variable.setName(name2);
        new CommentTracker().deleteAndRestoreComments((PsiElement)declaration2);
    }

    private static void inlineSingleAssignment(@NotNull PsiVariable resultVar, @NotNull PsiAssignmentExpression assignment, @NotNull PsiReferenceExpression resultUsage) {
        LOG.assertTrue(assignment.getParent() instanceof PsiExpressionStatement);
        if (assignment.getParent().getParent() != resultVar.getParent().getParent()) {
            return;
        }
        String name2 = Objects.requireNonNull(resultVar.getName());
        PsiDeclarationStatement declaration2 = JavaPsiFacade.getElementFactory((Project)resultVar.getProject()).createVariableDeclarationStatement(name2, resultVar.getType(), assignment.getRExpression());
        declaration2 = (PsiDeclarationStatement)assignment.getParent().replace((PsiElement)declaration2);
        resultVar.getParent().delete();
        resultVar = (PsiVariable)declaration2.getDeclaredElements()[0];
        PsiElement parentStatement = RefactoringUtil.getParentStatement((PsiElement)resultUsage, true);
        boolean canInline = false;
        for (PsiElement next = declaration2.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next.equals(parentStatement)) {
                canInline = true;
                break;
            }
            if (next instanceof PsiStatement) break;
        }
        if (canInline) {
            InlineUtil.inlineVariable(resultVar, resultVar.getInitializer(), (PsiJavaCodeReferenceElement)resultUsage);
            declaration2.delete();
        }
    }

    public static enum TailCallType {
        None(null),
        Simple((methodCopy, callSite, returnType) -> {
            InlineUtil.extractReturnValues(methodCopy, false);
            return null;
        }),
        Continue((methodCopy, callSite, returnType) -> {
            InlineUtil.extractReturnValues(methodCopy, true);
            return null;
        }),
        Invert((methodCopy, callSite, returnType) -> {
            for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiMethod)methodCopy)) {
                PsiExpression value2 = statement.getReturnValue();
                if (value2 == null) continue;
                CommentTracker ct = new CommentTracker();
                ct.replaceAndRestoreComments((PsiElement)value2, BoolUtils.getNegatedExpressionText(value2, ct));
            }
            return null;
        }),
        Return((methodCopy, callSite, returnType) -> null);

        @Nullable
        private final InlineTransformer myTransformer;

        private TailCallType(InlineTransformer transformer) {
            this.myTransformer = transformer;
        }

        @Nullable
        public InlineTransformer getTransformer() {
            return this.myTransformer;
        }
    }
}

