/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanonicalTypes {
    private CanonicalTypes() {
    }

    public static Type createTypeWrapper(@NotNull PsiType type2) {
        return (Type)type2.accept((PsiTypeVisitor)Creator.INSTANCE);
    }

    private static class Creator
    extends PsiTypeVisitor<Type> {
        public static final Creator INSTANCE = new Creator();
        private static final Logger LOG = Logger.getInstance(Creator.class);

        private Creator() {
        }

        public Type visitPrimitiveType(@NotNull PsiPrimitiveType type2) {
            return new Primitive(type2);
        }

        public Type visitEllipsisType(@NotNull PsiEllipsisType type2) {
            return new Ellipsis((PsiType)type2, this.substituteComponents((PsiArrayType)type2));
        }

        public Type visitArrayType(@NotNull PsiArrayType type2) {
            return new Array((PsiType)type2, this.substituteComponents(type2));
        }

        @NotNull
        private Type substituteComponents(PsiArrayType type2) {
            PsiType componentType = type2.getComponentType();
            Type substituted = (Type)componentType.accept((PsiTypeVisitor)this);
            LOG.assertTrue(substituted != null, (Object)componentType);
            return substituted;
        }

        public Type visitWildcardType(@NotNull PsiWildcardType type2) {
            PsiType bound = type2.getBound();
            return new WildcardType((PsiType)type2, type2.isExtends(), bound == null ? null : (Type)bound.accept((PsiTypeVisitor)this));
        }

        public Type visitClassType(@NotNull PsiClassType type2) {
            PsiClassType.ClassResolveResult resolveResult = type2.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass instanceof PsiAnonymousClass) {
                return this.visitClassType(((PsiAnonymousClass)aClass).getBaseClassType());
            }
            if (aClass == null) {
                return new UnresolvedType((PsiType)type2);
            }
            HashMap<String, Type> substitutionMap = new HashMap<String, Type>();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass)) {
                PsiType substitute = substitutor.substitute(typeParameter);
                substitutionMap.put(typeParameter.getName(), substitute != null ? (Type)substitute.accept((PsiTypeVisitor)this) : null);
            }
            String qualifiedName = (String)ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)Objects.requireNonNull(aClass.getName()));
            return new ClassType((PsiType)type2, qualifiedName, substitutionMap);
        }

        public Type visitDisjunctionType(@NotNull PsiDisjunctionType type2) {
            List types = ContainerUtil.map((Collection)type2.getDisjunctions(), type1 -> (Type)type1.accept((PsiTypeVisitor)this));
            return new LogicalOperationType(types, true);
        }

        @Nullable
        public Type visitIntersectionType(@NotNull PsiIntersectionType type2) {
            List types = ContainerUtil.map((Object[])type2.getConjuncts(), type1 -> (Type)type1.accept((PsiTypeVisitor)this));
            return new LogicalOperationType(types, false);
        }
    }

    private static class LogicalOperationType
    extends Type {
        private final List<? extends Type> myTypes;
        private final boolean myDisjunction;

        private LogicalOperationType(List<? extends Type> types, boolean disjunction) {
            this.myTypes = types;
            this.myDisjunction = disjunction;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            List types = ContainerUtil.map(this.myTypes, type2 -> type2.getType(context, manager));
            return this.myDisjunction ? new PsiDisjunctionType(types, manager) : PsiIntersectionType.createIntersection((List)types);
        }

        @Override
        public String getTypeText() {
            return StringUtil.join(this.myTypes, type2 -> type2.getTypeText(), (String)(this.myDisjunction ? "|" : "&"));
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            for (Type type2 : this.myTypes) {
                type2.addImportsTo(fragment);
            }
        }
    }

    private static class ClassType
    extends AnnotatedType {
        private final String myPresentableText;
        private final String myClassQName;
        private final Map<String, Type> mySubstitutor;

        private ClassType(@NotNull PsiType original, @NotNull String classQName, @NotNull Map<String, Type> substitutor) {
            super(TypeAnnotationProvider.Static.create((PsiAnnotation[])original.getAnnotations()));
            this.myPresentableText = original.getPresentableText(true);
            this.myClassQName = classQName;
            this.mySubstitutor = substitutor;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiElementFactory factory = facade.getElementFactory();
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(this.myClassQName, context);
            if (aClass == null) {
                return factory.createTypeFromText(this.myClassQName, context);
            }
            HashMap<PsiTypeParameter, PsiType> substitutionMap = new HashMap<PsiTypeParameter, PsiType>();
            Iterator iterator = PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass).iterator();
            while (iterator.hasNext()) {
                PsiTypeParameter typeParameter;
                Type substitute = this.mySubstitutor.get((typeParameter = (PsiTypeParameter)iterator.next()).getName());
                substitutionMap.put(typeParameter, substitute != null ? substitute.getType(context, manager) : null);
            }
            return factory.createType(aClass, factory.createSubstitutor(substitutionMap), null).annotate(this.myProvider);
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            fragment.addImportsFromString(this.myClassQName);
            for (Type type2 : this.mySubstitutor.values()) {
                if (type2 == null) continue;
                type2.addImportsTo(fragment);
            }
        }
    }

    private static class UnresolvedType
    extends Type {
        private final String myPresentableText;
        private final String myCanonicalText;

        private UnresolvedType(@NotNull PsiType original) {
            this.myPresentableText = original.getPresentableText(true);
            this.myCanonicalText = original.getCanonicalText(true);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            return JavaPsiFacade.getElementFactory((Project)manager.getProject()).createTypeFromText(this.myCanonicalText, context);
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    private static class WildcardType
    extends AnnotatedType {
        private final boolean myIsExtending;
        private final Type myBound;

        private WildcardType(@NotNull PsiType original, boolean isExtending, @Nullable Type bound) {
            super(original.getAnnotationProvider());
            this.myIsExtending = isExtending;
            this.myBound = bound;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiWildcardType type2;
            if (this.myBound == null) {
                type2 = PsiWildcardType.createUnbounded((PsiManager)manager);
            } else {
                PsiType boundType = this.myBound.getType(context, manager);
                if (boundType.equals(PsiType.NULL)) {
                    throw new IncorrectOperationException("Bound type is null " + this.getTypeText());
                }
                if (boundType instanceof PsiWildcardType) {
                    throw new IncorrectOperationException("Bound type is a wildcard " + this.getTypeText() + "; " + boundType.getCanonicalText());
                }
                type2 = this.myIsExtending ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)boundType) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)boundType);
            }
            return type2.annotate(this.myProvider);
        }

        @Override
        public String getTypeText() {
            return this.myBound == null ? "?" : "? " + (this.myIsExtending ? "extends " : "super ") + this.myBound.getTypeText();
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            if (this.myBound != null) {
                this.myBound.addImportsTo(fragment);
            }
        }

        @Override
        public boolean isValid() {
            return this.myBound == null || this.myBound.isValid();
        }
    }

    private static class Ellipsis
    extends Array {
        private Ellipsis(@NotNull PsiType original, @NotNull Type componentType) {
            super(original, componentType);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            return new PsiEllipsisType(this.myComponentType.getType(context, manager)).annotate(this.myProvider);
        }
    }

    private static class Array
    extends AnnotatedType {
        final Type myComponentType;
        private final String myPresentableText;

        private Array(@NotNull PsiType original, @NotNull Type componentType) {
            super(original.getAnnotationProvider());
            this.myPresentableText = original.getPresentableText(true);
            this.myComponentType = componentType;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            return this.myComponentType.getType(context, manager).createArrayType().annotate(this.myProvider);
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
            this.myComponentType.addImportsTo(fragment);
        }

        @Override
        public boolean isValid() {
            return this.myComponentType.isValid();
        }
    }

    private static class Primitive
    extends AnnotatedType {
        private final PsiPrimitiveType myType;

        private Primitive(@NotNull PsiPrimitiveType type2) {
            super(type2.getAnnotationProvider());
            this.myType = type2;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) {
            return this.myType.annotate(this.myProvider);
        }

        @Override
        public String getTypeText() {
            return this.myType.getPresentableText();
        }
    }

    private static abstract class AnnotatedType
    extends Type {
        protected final TypeAnnotationProvider myProvider;

        AnnotatedType(@NotNull TypeAnnotationProvider provider) {
            PsiAnnotation[] annotations = (PsiAnnotation[])ContainerUtil.map((Object[])provider.getAnnotations(), annotation -> (PsiAnnotation)annotation.copy(), (Object[])PsiAnnotation.EMPTY_ARRAY);
            this.myProvider = TypeAnnotationProvider.Static.create((PsiAnnotation[])annotations);
        }
    }

    public static abstract class Type {
        @NotNull
        public abstract PsiType getType(@Nullable PsiElement var1, PsiManager var2) throws IncorrectOperationException;

        @NotNull
        public PsiType getType(@NotNull PsiElement context) {
            return this.getType(context, context.getManager());
        }

        @NonNls
        public abstract String getTypeText();

        public void addImportsTo(@NotNull JavaCodeFragment fragment) {
        }

        public boolean isValid() {
            return true;
        }
    }
}

