/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.MigrateGetterNameSetting;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.DisjunctionTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.RootTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationRules {
    private final List<TypeConversionRule> myConversionRules;
    private final Map<Class, Object> myConversionCustomSettings = new HashMap<Class, Object>();
    private final Project myProject;
    private SearchScope mySearchScope;

    public TypeMigrationRules(@NotNull Project project) {
        this.myProject = project;
        List extensions = TypeConversionRule.EP_NAME.getExtensionList();
        this.myConversionRules = new ArrayList<TypeConversionRule>(extensions.size() + 2);
        this.myConversionRules.add(new RootTypeConversionRule());
        this.myConversionRules.add(new DisjunctionTypeConversionRule());
        this.myConversionRules.addAll(extensions);
        this.addConversionRuleSettings(new MigrateGetterNameSetting());
    }

    public void addConversionDescriptor(TypeConversionRule rule) {
        this.myConversionRules.add(rule);
    }

    public void addConversionRuleSettings(Object settings) {
        this.myConversionCustomSettings.put(settings.getClass(), settings);
    }

    public <T> T getConversionSettings(Class<T> aClass) {
        return (T)this.myConversionCustomSettings.get(aClass);
    }

    @NonNls
    @Nullable
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, boolean isCovariantPosition, TypeMigrationLabeler labeler) {
        TypeConversionDescriptorBase conversion = this.findConversion(from, to, member, context, labeler);
        if (conversion != null) {
            return conversion;
        }
        if (isCovariantPosition) {
            if (to instanceof PsiEllipsisType && TypeConversionUtil.isAssignable((PsiType)((PsiEllipsisType)to).getComponentType(), (PsiType)from)) {
                return new TypeConversionDescriptorBase();
            }
            if (TypeConversionUtil.isAssignable((PsiType)to, (PsiType)from)) {
                return new TypeConversionDescriptorBase();
            }
        }
        return !isCovariantPosition && TypeConversionUtil.isAssignable((PsiType)from, (PsiType)to) ? new TypeConversionDescriptorBase() : null;
    }

    @Nullable
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        for (TypeConversionRule descriptor : this.myConversionRules) {
            TypeConversionDescriptorBase conversion = descriptor.findConversion(from, to, member, context, labeler);
            if (conversion == null) continue;
            return conversion;
        }
        return null;
    }

    public boolean shouldConvertNull(PsiType from, PsiType to, PsiExpression context) {
        return this.myConversionRules.stream().anyMatch(rule -> rule.shouldConvertNullInitializer(from, to, context));
    }

    public void setBoundScope(@NotNull SearchScope searchScope) {
        this.mySearchScope = searchScope.intersectWith((SearchScope)GlobalSearchScope.notScope((GlobalSearchScope)LibraryScopeCache.getInstance((Project)this.myProject).getLibrariesOnlyScope()));
    }

    public SearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @Nullable
    public Pair<PsiType, PsiType> bindTypeParameters(PsiType from, PsiType to, PsiMethod method, PsiExpression context, TypeMigrationLabeler labeler) {
        for (TypeConversionRule conversionRule : this.myConversionRules) {
            Pair<PsiType, PsiType> typePair = conversionRule.bindTypeParameters(from, to, method, context, labeler);
            if (typePair == null) continue;
            return typePair;
        }
        return null;
    }
}

