/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.AbstractJavaMemberCallerChooser;
import com.intellij.refactoring.changeSignature.inCallers.JavaMemberNode;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteMemberCalleeUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SafeDeleteJavaCalleeChooser
extends AbstractJavaMemberCallerChooser<PsiMember> {
    private final Project myProject;

    SafeDeleteJavaCalleeChooser(PsiMember member, Project project, ArrayList<UsageInfo> result) {
        super(member, project, JavaRefactoringBundle.message((String)"safe.delete.select.members.to.propagate.dialog.title", (Object[])new Object[0]), null, members -> result.addAll(ContainerUtil.map((Collection)members, m -> new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)m, (PsiElement)m, true))));
        this.myProject = project;
    }

    protected abstract ArrayList<SafeDeleteMemberCalleeUsageInfo> getTopLevelItems();

    @Override
    @NotNull
    protected String getMemberTypePresentableText() {
        return "member";
    }

    protected PsiMember[] findDeepestSuperMethods(PsiMember method) {
        return method instanceof PsiMethod ? ((PsiMethod)method).findDeepestSuperMethods() : PsiMember.EMPTY_ARRAY;
    }

    @Nullable
    static List<PsiMember> computeCalleesSafeToDelete(PsiMember psiMember) {
        PsiClass containingClass;
        PsiCodeBlock body2;
        if (psiMember instanceof PsiMethod) {
            body2 = ((PsiMethod)psiMember).getBody();
        } else {
            assert (psiMember instanceof PsiField);
            body2 = ((PsiField)psiMember).getInitializer();
        }
        if (body2 != null && (containingClass = psiMember.getContainingClass()) != null) {
            final HashSet membersToCheck = new HashSet();
            body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    PsiElement resolved = expression2.resolve();
                    if (resolved instanceof PsiMethod || resolved instanceof PsiField) {
                        ContainerUtil.addAllNotNull((Collection)membersToCheck, (Object[])new PsiMember[]{(PsiMember)resolved});
                    }
                }
            });
            return membersToCheck.stream().filter(m -> containingClass.equals(m.getContainingClass()) && !psiMember.equals(m)).filter(m -> !(m instanceof PsiMethod) || ((PsiMethod)m).findDeepestSuperMethods().length == 0).filter(m -> SafeDeleteJavaCalleeChooser.usedOnlyIn(m, psiMember)).collect(Collectors.toList());
        }
        return null;
    }

    protected JavaMemberNode<PsiMember> createTreeNodeFor(PsiMember nodeMethod, HashSet<PsiMember> callees, Runnable cancelCallback) {
        SafeDeleteJavaMemberNode node = new SafeDeleteJavaMemberNode(nodeMethod, callees, cancelCallback, nodeMethod != null ? nodeMethod.getProject() : this.myProject);
        if (((PsiMember)this.getTopMember()).equals(nodeMethod)) {
            node.setEnabled(false);
            node.setChecked(true);
        }
        return node;
    }

    protected MemberNodeBase<PsiMember> getCalleeNode(MemberNodeBase<PsiMember> node) {
        return node;
    }

    protected MemberNodeBase<PsiMember> getCallerNode(MemberNodeBase<PsiMember> node) {
        return (MemberNodeBase)node.getParent();
    }

    private static boolean usedOnlyIn(final @NotNull PsiMember explored, final @NotNull PsiMember place) {
        return ReferencesSearch.search((PsiElement)explored).forEach((Processor)new CommonProcessors.CollectProcessor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                return PsiTreeUtil.isAncestor((PsiElement)place, (PsiElement)element, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)explored, (PsiElement)element, (boolean)true);
            }
        });
    }

    private class SafeDeleteJavaMemberNode
    extends JavaMemberNode<PsiMember> {
        SafeDeleteJavaMemberNode(PsiMember currentMember, HashSet<PsiMember> callees, Runnable cancelCallback, Project project) {
            super(currentMember, callees, project, cancelCallback);
        }

        protected MemberNodeBase<PsiMember> createNode(PsiMember caller, HashSet<PsiMember> callees) {
            return new SafeDeleteJavaMemberNode(caller, callees, this.myCancelCallback, this.myProject);
        }

        protected List<PsiMember> computeCallers() {
            if (((PsiMember)SafeDeleteJavaCalleeChooser.this.getTopMember()).equals(this.getMember())) {
                return ContainerUtil.map(SafeDeleteJavaCalleeChooser.this.getTopLevelItems(), info -> info.getCalledMember());
            }
            List<PsiMember> callees = SafeDeleteJavaCalleeChooser.computeCalleesSafeToDelete((PsiMember)this.getMember());
            if (callees != null) {
                callees.remove(SafeDeleteJavaCalleeChooser.this.getTopMember());
                return callees;
            }
            return Collections.emptyList();
        }

        protected Condition<PsiMember> getFilter() {
            return member -> !((PsiMember)this.getMember()).equals(member);
        }
    }
}

