/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.replaceConstructorWithBuilder.ParameterData;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderProcessor;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConstructorWithBuilderDialog
extends RefactoringDialog {
    private final PsiMethod[] myConstructors;
    private JRadioButton myCreateBuilderClassRadioButton;
    private JRadioButton myExistingBuilderClassRadioButton;
    private JPanel myWholePanel;
    private JTextField myNewClassName;
    private ReferenceEditorComboWithBrowseButton myPackageTextField;
    private ReferenceEditorComboWithBrowseButton myExistentClassTF;
    private ComboboxWithBrowseButton myDestinationCb;
    private JPanel myCreateNewPanel;
    private static final Logger LOG = Logger.getInstance(ReplaceConstructorWithBuilderDialog.class);
    private final LinkedHashMap<String, ParameterData> myParametersMap;
    private MyTableModel myTableModel;
    private JBTable myTable;
    private String mySetterPrefix;
    private static final String RECENT_KEYS = "ReplaceConstructorWithBuilder.RECENT_KEYS";
    private static final String SETTER_PREFIX_KEY = "ConstructorWithBuilder.SetterPrefix";
    private static final int PARAM = 0;
    private static final int FIELD = 1;
    private static final int SETTER = 2;
    private static final int DEFAULT_VALUE = 3;
    private static final int SKIP_SETTER = 4;

    protected ReplaceConstructorWithBuilderDialog(@NotNull Project project, PsiMethod[] constructors) {
        super(project, false);
        this.myConstructors = constructors;
        this.$$$setupUI$$$();
        this.myParametersMap = new LinkedHashMap();
        this.mySetterPrefix = PropertiesComponent.getInstance((Project)project).getValue(SETTER_PREFIX_KEY, "set");
        for (PsiMethod constructor : constructors) {
            ParameterData.createFromConstructor(constructor, this.mySetterPrefix, this.myParametersMap);
        }
        this.init();
        this.setTitle("Replace Constructor with Builder");
    }

    protected String getHelpId() {
        return "replace_constructor_with_builder_dialog";
    }

    protected void doAction() {
        String packageName;
        String className2;
        TableUtil.stopEditing((JTable)this.myTable);
        if (this.myCreateBuilderClassRadioButton.isSelected()) {
            className2 = this.myNewClassName.getText().trim();
            packageName = this.myPackageTextField.getText().trim();
        } else {
            String fqName = this.myExistentClassTF.getText().trim();
            className2 = StringUtil.getShortName((String)fqName);
            packageName = StringUtil.getPackageName((String)fqName);
            PsiClass builderClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(StringUtil.getQualifiedName((String)packageName, (String)className2), GlobalSearchScope.projectScope((Project)this.myProject));
            if (builderClass != null && !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)builderClass)) {
                return;
            }
        }
        this.invokeRefactoring((BaseRefactoringProcessor)new ReplaceConstructorWithBuilderProcessor(this.getProject(), this.myConstructors, this.myParametersMap, className2, packageName, ((DestinationFolderComboBox)this.myDestinationCb).selectDirectory(new PackageWrapper(this.myConstructors[0].getManager(), packageName), false), this.myCreateBuilderClassRadioButton.isSelected()));
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)new JLabel(JavaRefactoringBundle.message((String)"constructor.with.builder.parameters.to.pass.to.the.builder.title", (Object[])new Object[0])), "Center");
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction(new AnAction(JavaRefactoringBundle.message((String)"constructor.with.builder.rename.setters.prefix.action.name", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ReplaceConstructorWithBuilderDialog.this.applyNewSetterPrefix();
            }
        }).setAsSecondary(true);
        panel2.add((Component)ActionManager.getInstance().createActionToolbar("ReplaceConstructorWithBuilder", (ActionGroup)actionGroup, true).getComponent(), "East");
        Box box = Box.createHorizontalBox();
        box.add(panel2);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void applyNewSetterPrefix() {
        String setterPrefix = Messages.showInputDialog((Component)this.myTable, (String)JavaRefactoringBundle.message((String)"constructor.with.builder.new.setter.prefix.dialog.message", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"constructor.with.builder.rename.setters.prefix.action.name", (Object[])new Object[0]), null, (String)this.mySetterPrefix, (InputValidator)new MySetterPrefixInputValidator());
        if (setterPrefix != null) {
            this.mySetterPrefix = setterPrefix;
            PropertiesComponent.getInstance((Project)this.myProject).setValue(SETTER_PREFIX_KEY, setterPrefix);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
            for (String paramName : this.myParametersMap.keySet()) {
                ParameterData data = this.myParametersMap.get(paramName);
                paramName = data.getParamName();
                String propertyName = javaCodeStyleManager.variableNameToPropertyName(paramName, VariableKind.PARAMETER);
                data.setSetterName(PropertyUtilBase.suggestSetterName((String)propertyName, (String)setterPrefix));
            }
            this.myTable.revalidate();
            this.myTable.repaint();
        }
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(true);
        splitter.setFirstComponent((JComponent)this.createTablePanel());
        splitter.setSecondComponent((JComponent)this.myWholePanel);
        ActionListener enableDisableListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReplaceConstructorWithBuilderDialog.this.setEnabled(ReplaceConstructorWithBuilderDialog.this.myCreateBuilderClassRadioButton.isSelected());
                IdeFocusManager.getInstance((Project)ReplaceConstructorWithBuilderDialog.this.myProject).requestFocus((Component)(ReplaceConstructorWithBuilderDialog.this.myCreateBuilderClassRadioButton.isSelected() ? ReplaceConstructorWithBuilderDialog.this.myNewClassName : ReplaceConstructorWithBuilderDialog.this.myExistentClassTF.getChildComponent()), true);
                ReplaceConstructorWithBuilderDialog.this.validateButtons();
            }
        };
        this.myCreateBuilderClassRadioButton.addActionListener(enableDisableListener);
        this.myExistingBuilderClassRadioButton.addActionListener(enableDisableListener);
        this.myCreateBuilderClassRadioButton.setSelected(true);
        this.setEnabled(true);
        DocumentAdapter validateButtonsListener = new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                ReplaceConstructorWithBuilderDialog.this.validateButtons();
            }
        };
        this.myNewClassName.getDocument().addDocumentListener((javax.swing.event.DocumentListener)validateButtonsListener);
        PsiClass psiClass = this.myConstructors[0].getContainingClass();
        LOG.assertTrue(psiClass != null);
        this.myNewClassName.setText(psiClass.getName() + "Builder");
        return splitter;
    }

    private void setEnabled(boolean createNew) {
        UIUtil.setEnabled((Component)this.myCreateNewPanel, (boolean)createNew, (boolean)true);
        this.myExistentClassTF.setEnabled(!createNew);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNewClassName;
    }

    protected void canRun() throws ConfigurationException {
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        for (ParameterData parameterData : this.myParametersMap.values()) {
            if (!nameHelper.isIdentifier(parameterData.getFieldName())) {
                throw new ConfigurationException("'" + parameterData.getFieldName() + "' is not a valid field name");
            }
            if (nameHelper.isIdentifier(parameterData.getSetterName())) continue;
            throw new ConfigurationException("'" + parameterData.getSetterName() + "' is not a valid setter name");
        }
        if (this.myCreateBuilderClassRadioButton.isSelected()) {
            String className2 = this.myNewClassName.getText().trim();
            if (className2.length() == 0 || !nameHelper.isQualifiedName(className2)) {
                throw new ConfigurationException("'" + className2 + "' is invalid builder class name");
            }
            String packageName = this.myPackageTextField.getText().trim();
            if (packageName.length() > 0 && !nameHelper.isQualifiedName(packageName)) {
                throw new ConfigurationException("'" + packageName + "' is invalid builder package name");
            }
        } else {
            String qualifiedName = this.myExistentClassTF.getText().trim();
            if (qualifiedName.length() == 0 || !nameHelper.isQualifiedName(qualifiedName)) {
                throw new ConfigurationException("'" + qualifiedName + "' is invalid builder qualified class name");
            }
        }
    }

    private JScrollPane createTablePanel() {
        this.myTableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        this.myTable.setSurrendersFocusOnKeystroke(true);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        columnModel.getColumn(4).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows;
                for (int selectedRow : selectedRows = ReplaceConstructorWithBuilderDialog.this.myTable.getSelectedRows()) {
                    ParameterData parameterData = ReplaceConstructorWithBuilderDialog.this.myTableModel.getParamData(selectedRow);
                    if (parameterData.getDefaultValue() == null) continue;
                    parameterData.setInsertSetter(!parameterData.isInsertSetter());
                }
                TableUtil.selectRows((JTable)ReplaceConstructorWithBuilderDialog.this.myTable, (int[])selectedRows);
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)550, (int)-1));
        this.myTable.setVisibleRowCount(12);
        this.myTable.getSelectionModel().setSelectionMode(2);
        return ScrollPaneFactory.createScrollPane((Component)this.myTable);
    }

    private void createUIComponents() {
        DocumentListener adapter = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                ReplaceConstructorWithBuilderDialog.this.validateButtons();
            }
        };
        this.myPackageTextField = new PackageNameReferenceEditorCombo(((PsiJavaFile)this.myConstructors[0].getContainingFile()).getPackageName(), this.myProject, RECENT_KEYS, RefactoringBundle.message((String)"choose.destination.package"));
        ((EditorComboBox)this.myPackageTextField.getChildComponent()).getDocument().addDocumentListener(adapter);
        this.myDestinationCb = new DestinationFolderComboBox(){

            @Override
            public String getTargetPackage() {
                return ReplaceConstructorWithBuilderDialog.this.myPackageTextField.getText().trim();
            }
        };
        ((DestinationFolderComboBox)this.myDestinationCb).setData(this.myProject, this.myConstructors[0].getContainingFile().getContainingDirectory(), (EditorComboBox)this.myPackageTextField.getChildComponent());
        this.myExistentClassTF = new ReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)ReplaceConstructorWithBuilderDialog.this.getProject()).createWithInnerClassesScopeChooser("Select Builder Class", GlobalSearchScope.projectScope((Project)ReplaceConstructorWithBuilderDialog.this.myProject), null, null);
                String classText = ReplaceConstructorWithBuilderDialog.this.myExistentClassTF.getText();
                PsiClass currentClass = JavaPsiFacade.getInstance((Project)ReplaceConstructorWithBuilderDialog.this.myProject).findClass(classText, GlobalSearchScope.allScope((Project)ReplaceConstructorWithBuilderDialog.this.myProject));
                if (currentClass != null) {
                    chooser.select(currentClass);
                }
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelected();
                if (selectedClass != null) {
                    ReplaceConstructorWithBuilderDialog.this.myExistentClassTF.setText(selectedClass.getQualifiedName());
                }
            }
        }, "", this.myProject, true, RECENT_KEYS);
        ((EditorComboBox)this.myExistentClassTF.getChildComponent()).getDocument().addDocumentListener(adapter);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.fill = 3;
        jPanel2.add((Component)jPanel4, gridBagConstraints2);
        this.myCreateBuilderClassRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", ReplaceConstructorWithBuilderDialog.class).getString("replace.constructor.builder.create.new"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)jRadioButton2, gridBagConstraints3);
        this.myExistingBuilderClassRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", ReplaceConstructorWithBuilderDialog.class).getString("replace.constructor.builder.use.existing"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 5;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(5, 0, 0, 0);
        jPanel2.add((Component)jRadioButton, gridBagConstraints4);
        this.myCreateNewPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(5, 20, 0, 0);
        jPanel2.add((Component)jPanel, gridBagConstraints5);
        this.myNewClassName = jTextField = new JTextField();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 1;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        jPanel.add((Component)jTextField, gridBagConstraints6);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", ReplaceConstructorWithBuilderDialog.class).getString("replace.constructor.new.builder.class.name"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints7);
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton = this.myPackageTextField;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 3;
        gridBagConstraints8.fill = 2;
        jPanel.add((Component)((Object)referenceEditorComboWithBrowseButton), gridBagConstraints8);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", ReplaceConstructorWithBuilderDialog.class).getString("replace.constructor.new.builder.package"));
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 2;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints9);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/RefactoringBundle", ReplaceConstructorWithBuilderDialog.class).getString("target.destination.folder"));
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 4;
        gridBagConstraints10.anchor = 17;
        jPanel.add((Component)jLabel3, gridBagConstraints10);
        ComboboxWithBrowseButton comboboxWithBrowseButton = this.myDestinationCb;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 5;
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.fill = 2;
        jPanel.add((Component)comboboxWithBrowseButton, gridBagConstraints11);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 6;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.insets = new Insets(5, 20, 0, 0);
        jPanel2.add((Component)jPanel5, gridBagConstraints12);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", ReplaceConstructorWithBuilderDialog.class).getString("replace.constructor.existing.builder.fqn"));
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.anchor = 17;
        jPanel5.add((Component)jLabel4, gridBagConstraints13);
        ReferenceEditorComboWithBrowseButton referenceEditorComboWithBrowseButton2 = this.myExistentClassTF;
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.gridy = 1;
        gridBagConstraints14.gridwidth = 2;
        gridBagConstraints14.fill = 2;
        jPanel5.add((Component)((Object)referenceEditorComboWithBrowseButton2), gridBagConstraints14);
        JPanel jPanel6 = new JPanel();
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = 1;
        gridBagConstraints15.gridy = 0;
        gridBagConstraints15.weightx = 1.0;
        gridBagConstraints15.fill = 2;
        jPanel5.add((Component)jPanel6, gridBagConstraints15);
        jLabel.setLabelFor(jTextField);
        jLabel3.setLabelFor((Component)comboboxWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MySetterPrefixInputValidator
    implements InputValidatorEx {
        private MySetterPrefixInputValidator() {
        }

        public boolean checkInput(String inputString) {
            return this.getErrorText(inputString) == null;
        }

        public boolean canClose(String inputString) {
            return this.checkInput(inputString);
        }

        @Nullable
        public String getErrorText(String inputString) {
            if (StringUtil.isEmpty((String)inputString)) {
                return null;
            }
            return !PsiNameHelper.getInstance((Project)ReplaceConstructorWithBuilderDialog.this.myProject).isIdentifier(inputString) ? "Identifier '" + inputString + "' is invalid" : null;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return ReplaceConstructorWithBuilderDialog.this.myParametersMap.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ParameterData data = this.getParamData(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return data.getType().getCanonicalText() + " " + data.getParamName();
                }
                case 1: {
                    return data.getFieldName();
                }
                case 2: {
                    return data.getSetterName();
                }
                case 3: {
                    return data.getDefaultValue();
                }
                case 4: {
                    return !data.isInsertSetter();
                }
            }
            return null;
        }

        private ParameterData getParamData(int rowIndex) {
            return (ParameterData)ReplaceConstructorWithBuilderDialog.this.myParametersMap.get(new ArrayList(ReplaceConstructorWithBuilderDialog.this.myParametersMap.keySet()).get(rowIndex));
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ParameterData data = this.getParamData(rowIndex);
            switch (columnIndex) {
                case 1: {
                    data.setFieldName((String)aValue);
                    break;
                }
                case 2: {
                    data.setSetterName((String)aValue);
                    break;
                }
                case 3: {
                    data.setDefaultValue((String)aValue);
                    break;
                }
                case 4: {
                    data.setInsertSetter((Boolean)aValue == false);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Parameter";
                }
                case 1: {
                    return "Field Name";
                }
                case 2: {
                    return "Setter Name";
                }
                case 3: {
                    return "Default Value";
                }
                case 4: {
                    return "Optional Setter";
                }
            }
            assert (false) : "unknown column " + column;
            return null;
        }
    }
}

