/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.FieldHidesLocalUsageInfo;
import com.intellij.refactoring.rename.JavaUnresolvableLocalCollisionDetector;
import com.intellij.refactoring.rename.LocalHidesFieldUsageInfo;
import com.intellij.refactoring.rename.MemberHidesOuterMemberUsageInfo;
import com.intellij.refactoring.rename.MemberHidesStaticImportUsageInfo;
import com.intellij.refactoring.rename.RenameJavaMemberProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.SubmemberHidesMemberUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticGetterSetterRenamer;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameJavaVariableProcessor
extends RenameJavaMemberProcessor {
    private static final Logger LOG = Logger.getInstance(RenameJavaVariableProcessor.class);

    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PsiVariable;
    }

    public void renameElement(@NotNull PsiElement psiElement, @NotNull String newName, UsageInfo @NotNull [] usages, @Nullable RefactoringElementListener listener) throws IncorrectOperationException {
        PsiVariable variable = (PsiVariable)psiElement;
        ArrayList<MemberHidesOuterMemberUsageInfo> outerHides = new ArrayList<MemberHidesOuterMemberUsageInfo>();
        ArrayList<MemberHidesStaticImportUsageInfo> staticImportHides = new ArrayList<MemberHidesStaticImportUsageInfo>();
        ArrayList<PsiElement> occurrencesToCheckForConflict = new ArrayList<PsiElement>();
        for (UsageInfo usage : usages) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement collidingRef;
            PsiElement element = usage.getElement();
            if (element == null) continue;
            if (usage instanceof MemberHidesStaticImportUsageInfo) {
                staticImportHides.add((MemberHidesStaticImportUsageInfo)usage);
                continue;
            }
            if (usage instanceof LocalHidesFieldUsageInfo) {
                collidingRef = (PsiJavaCodeReferenceElement)element;
                resolved = collidingRef.resolve();
                if (!(resolved instanceof PsiField)) continue;
                RenameJavaVariableProcessor.qualifyMember((PsiMember)((PsiField)resolved), (PsiElement)collidingRef, newName);
                continue;
            }
            if (usage instanceof MemberHidesOuterMemberUsageInfo) {
                collidingRef = (PsiJavaCodeReferenceElement)element;
                resolved = (PsiField)collidingRef.resolve();
                outerHides.add(new MemberHidesOuterMemberUsageInfo(element, (PsiMember)resolved));
                continue;
            }
            PsiReference ref = usage instanceof MoveRenameUsageInfo ? usage.getReference() : element.getReference();
            if (ref == null) continue;
            PsiElement newElem = ref.handleElementRename(newName);
            if (!(variable instanceof PsiField)) continue;
            occurrencesToCheckForConflict.add(newElem);
        }
        variable.setName(newName);
        if (listener != null) {
            listener.elementRenamed((PsiElement)variable);
        }
        if (variable instanceof PsiField) {
            for (PsiElement occurrence : occurrencesToCheckForConflict) {
                RenameJavaVariableProcessor.fixPossibleNameCollisionsForFieldRenaming((PsiField)variable, newName, occurrence);
            }
        }
        RenameJavaVariableProcessor.qualifyOuterMemberReferences(outerHides);
        RenameJavaVariableProcessor.qualifyStaticImportReferences(staticImportHides);
    }

    private static void fixPossibleNameCollisionsForFieldRenaming(PsiField field, String newName, PsiElement replacedOccurence) throws IncorrectOperationException {
        if (!(replacedOccurence instanceof PsiReferenceExpression)) {
            return;
        }
        PsiElement elem = ((PsiReferenceExpression)replacedOccurence).resolve();
        if (elem == null || elem == field || elem.isEquivalentTo((PsiElement)field)) {
            return;
        }
        if (elem instanceof PsiLocalVariable || elem instanceof PsiParameter || elem instanceof PsiField && elem != replacedOccurence) {
            RenameJavaVariableProcessor.qualifyMember((PsiMember)field, replacedOccurence, newName);
        }
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        String name2;
        PsiClass containingClass;
        if (element instanceof PsiRecordComponent && (containingClass = ((PsiRecordComponent)element).getContainingClass()) != null && (name2 = ((PsiRecordComponent)element).getName()) != null) {
            PsiParameter parameter2;
            PsiMethod canonicalConstructor;
            PsiMethod explicitGetter = (PsiMethod)ContainerUtil.find((Object[])containingClass.findMethodsByName(name2, false), m -> m.getParameterList().isEmpty());
            if (explicitGetter != null) {
                AutomaticGetterSetterRenamer.addOverriddenAndImplemented(explicitGetter, newName, null, newName, JavaCodeStyleManager.getInstance((Project)element.getProject()), allRenames);
            }
            if ((canonicalConstructor = (PsiMethod)ContainerUtil.find((Object[])containingClass.getConstructors(), c -> JavaPsiRecordUtil.isExplicitCanonicalConstructor(c))) != null && (parameter2 = (PsiParameter)ContainerUtil.find((Object[])canonicalConstructor.getParameterList().getParameters(), p -> name2.equals(p.getName()))) != null) {
                allRenames.put((PsiElement)parameter2, newName);
            }
        }
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            RenameJavaVariableProcessor.findMemberHidesOuterMemberCollisions((PsiMember)field, newName, result);
            RenameJavaVariableProcessor.findSubmemberHidesFieldCollisions(field, newName, result);
            RenameJavaVariableProcessor.findCollisionsAgainstNewName((PsiMember)field, newName, result);
        } else if (element instanceof PsiLocalVariable || element instanceof PsiParameter) {
            JavaUnresolvableLocalCollisionDetector.findCollisions(element, newName, result);
            RenameJavaVariableProcessor.findLocalHidesFieldCollisions(element, newName, allRenames, result);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        for (PsiElement psiElement : allRenames.keySet()) {
            RenamePsiElementProcessor.forElement((PsiElement)psiElement).findExistingNameConflicts(psiElement, allRenames.get(psiElement), conflicts);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element instanceof PsiCompiledElement) {
            return;
        }
        if (element instanceof PsiField) {
            PsiField refactoredField = (PsiField)element;
            if (newName.equals(refactoredField.getName())) {
                return;
            }
            ConflictsUtil.checkFieldConflicts(refactoredField.getContainingClass(), newName, conflicts);
        }
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        if (element instanceof PsiField) {
            return "refactoring.renameField";
        }
        if (element instanceof PsiLocalVariable) {
            return "refactoring.renameVariable";
        }
        if (element instanceof PsiParameter) {
            return "refactoring.renameParameter";
        }
        return null;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element instanceof PsiField) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element instanceof PsiField) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD = enabled;
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element instanceof PsiField) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD;
        }
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element instanceof PsiField) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD = enabled;
        }
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE = enabled;
    }

    private static void findSubmemberHidesFieldCollisions(PsiField field, String newName, List<? super UsageInfo> result) {
        if (field.getContainingClass() == null) {
            return;
        }
        if (field.hasModifierProperty("private")) {
            return;
        }
        PsiClass containingClass = field.getContainingClass();
        Collection inheritors = ClassInheritorsSearch.search((PsiClass)containingClass).findAll();
        for (PsiClass inheritor : inheritors) {
            PsiField conflictingField = inheritor.findFieldByName(newName, false);
            if (conflictingField != null) {
                result.add((UsageInfo)new SubmemberHidesMemberUsageInfo((PsiElement)conflictingField, (PsiElement)field));
                continue;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)inheritor, PsiMember.class);
            if (member == null) continue;
            ArrayList variables = new ArrayList();
            ControlFlowUtil.collectOuterLocals(variables, (PsiElement)inheritor, (PsiElement)inheritor, (PsiElement)member);
            for (PsiVariable variable : variables) {
                if (!newName.equals(variable.getName())) continue;
                result.add((UsageInfo)new FieldHidesLocalUsageInfo((PsiElement)variable, (PsiElement)field));
            }
        }
    }

    private static void findLocalHidesFieldCollisions(final PsiElement element, final String newName, final Map<? extends PsiElement, String> allRenames, final List<? super UsageInfo> result) {
        if (!(element instanceof PsiLocalVariable) && !(element instanceof PsiParameter)) {
            return;
        }
        PsiClass toplevel = PsiUtil.getTopLevelClass((PsiElement)element);
        if (toplevel == null) {
            return;
        }
        PsiElement scopeElement = element instanceof PsiLocalVariable ? RefactoringUtil.getVariableScope((PsiLocalVariable)element) : ((PsiParameter)element).getDeclarationScope();
        LOG.assertTrue(scopeElement != null);
        scopeElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiElement resolved;
                super.visitReferenceExpression(expression2);
                if (!expression2.isQualified() && (resolved = expression2.resolve()) instanceof PsiField) {
                    String fieldNewName;
                    PsiField field = (PsiField)resolved;
                    String string = fieldNewName = allRenames.containsKey(field) ? (String)allRenames.get(field) : field.getName();
                    if (newName.equals(fieldNewName)) {
                        result.add(new LocalHidesFieldUsageInfo((PsiElement)expression2, element));
                    }
                }
            }
        });
    }

    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        String qualifiedName;
        PsiField field;
        PsiClass containingClass;
        if (nonJava && element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return StringUtil.getQualifiedName((String)qualifiedName, (String)newName);
        }
        return null;
    }
}

