/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.search.ProjectScope;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RenameJavaModuleProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        return element instanceof PsiJavaModule;
    }

    public void findCollisions(@NotNull PsiElement element, final @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result) {
        Project project = element.getProject();
        PsiJavaModule existing = (PsiJavaModule)ContainerUtil.getFirstItem((Collection)JavaPsiFacade.getInstance((Project)project).findModules(newName, ProjectScope.getProjectScope((Project)project)));
        if (existing != null) {
            result.add((UsageInfo)new UnresolvableCollisionUsageInfo(element, (PsiElement)existing){

                public String getDescription() {
                    return JavaRefactoringBundle.message((String)"rename.module.already.exists", (Object[])new Object[]{newName});
                }
            });
        }
    }
}

