/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageRenameValidator
implements RenameInputValidatorEx {
    private final ElementPattern<? extends PsiElement> myPattern = PlatformPatterns.psiElement(PsiPackage.class);

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        return this.myPattern;
    }

    @Nullable
    public String getErrorMessage(@NotNull String newName, @NotNull Project project) {
        if (FileTypeManager.getInstance().isFileIgnored(newName)) {
            return "Trying to create a package with ignored name, result will not be visible";
        }
        if (newName.length() > 0 && !PsiDirectoryFactory.getInstance((Project)project).isValidPackageName(newName)) {
            return "Not a valid package name";
        }
        return null;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        return !newName.isEmpty();
    }
}

