/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.ide.util.EditorHelper;
import com.intellij.model.ModelBranch;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.move.MoveMemberViewDescriptor;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersImpl;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveMembersProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MoveMembersProcessor.class);
    private PsiClass myTargetClass;
    private final Set<PsiMember> myMembersToMove = new LinkedHashSet<PsiMember>();
    private final MoveCallback myMoveCallback;
    private final boolean myOpenInEditor;
    private String myNewVisibility;
    private String myCommandName = MoveMembersImpl.getRefactoringName();
    private MoveMembersOptions myOptions;

    public MoveMembersProcessor(Project project, MoveMembersOptions options) {
        this(project, null, options);
    }

    public MoveMembersProcessor(Project project, @Nullable MoveCallback moveCallback, MoveMembersOptions options) {
        this(project, moveCallback, options, false);
    }

    public MoveMembersProcessor(Project project, @Nullable MoveCallback moveCallback, MoveMembersOptions options, boolean openInEditor) {
        super(project);
        this.myMoveCallback = moveCallback;
        this.myOpenInEditor = openInEditor;
        this.setOptions(options);
    }

    @NotNull
    protected String getCommandName() {
        return this.myCommandName;
    }

    private void setOptions(MoveMembersOptions dialog) {
        this.myOptions = dialog;
        Object[] members = dialog.getSelectedMembers();
        this.myMembersToMove.clear();
        ContainerUtil.addAll(this.myMembersToMove, (Object[])members);
        this.setCommandName((PsiMember[])members);
        String targetClassName = dialog.getTargetClassName();
        this.myTargetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(targetClassName, GlobalSearchScope.projectScope((Project)this.myProject));
        LOG.assertTrue(this.myTargetClass != null, (Object)("target class: " + targetClassName));
        this.myNewVisibility = dialog.getMemberVisibility();
    }

    private void setCommandName(PsiMember[] members) {
        StringBuilder commandName = new StringBuilder();
        commandName.append(MoveHandler.getRefactoringName());
        commandName.append(" ");
        boolean first = true;
        for (PsiMember member : members) {
            if (!first) {
                commandName.append(", ");
            }
            commandName.append(UsageViewUtil.getType((PsiElement)member));
            commandName.append(' ');
            commandName.append(UsageViewUtil.getShortName((PsiElement)member));
            first = false;
        }
        this.myCommandName = commandName.toString();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        return new MoveMemberViewDescriptor(PsiUtilCore.toPsiElementArray(this.myMembersToMove));
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<MoveMembersUsageInfo> usagesList = new ArrayList<MoveMembersUsageInfo>();
        for (PsiMember member : this.myMembersToMove) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member)) {
                PsiElement ref = psiReference.getElement();
                MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(ref.getLanguage());
                MoveMembersUsageInfo usage = null;
                if (handler != null && this.myTargetClass != null) {
                    usage = handler.getUsage(member, psiReference, this.myMembersToMove, this.myTargetClass);
                }
                if (usage != null) {
                    usagesList.add(usage);
                    continue;
                }
                if (this.isInMovedElement(ref)) continue;
                usagesList.add(new MoveMembersUsageInfo(member, ref, null, ref, psiReference));
            }
        }
        UsageInfo[] usageInfos = usagesList.toArray(UsageInfo.EMPTY_ARRAY);
        usageInfos = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        return usageInfos;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        LOG.assertTrue(this.myMembersToMove.size() == elements.length);
        this.myMembersToMove.clear();
        for (PsiElement resolved : elements) {
            this.myMembersToMove.add((PsiMember)resolved);
        }
    }

    private boolean isInMovedElement(PsiElement element) {
        for (PsiMember member : this.myMembersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    protected boolean canPerformRefactoringInBranch() {
        return true;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiClass targetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myOptions.getTargetClassName(), GlobalSearchScope.projectScope((Project)this.myProject));
        if (targetClass == null) {
            return;
        }
        Map<PsiMember, SmartPsiElementPointer<PsiMember>> movedMembers = this.performMove(targetClass, this.myMembersToMove, ContainerUtil.map((Object[])usages, MoveMembersUsageInfo.class::cast));
        this.afterAllMovements(movedMembers);
    }

    protected void performRefactoringInBranch(UsageInfo @NotNull [] originalUsages, ModelBranch branch) {
        PsiClass targetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myOptions.getTargetClassName(), GlobalSearchScope.projectScope((Project)this.myProject));
        if (targetClass == null) {
            return;
        }
        PsiClass targetCopy = (PsiClass)branch.obtainPsiCopy((PsiElement)targetClass);
        LinkedHashSet<PsiMember> membersToMove = new LinkedHashSet<PsiMember>(ContainerUtil.map(this.myMembersToMove, arg_0 -> ((ModelBranch)branch).obtainPsiCopy(arg_0)));
        List usages = ContainerUtil.map((Object[])originalUsages, u -> ((MoveMembersUsageInfo)((Object)u)).branched(branch));
        Map<PsiMember, SmartPsiElementPointer<PsiMember>> movedMembers = this.performMove(targetCopy, membersToMove, usages);
        branch.runAfterMerge(() -> {
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            this.afterAllMovements(EntryStream.of((Map)movedMembers).mapValues(p -> {
                PsiMember member = (PsiMember)p.getElement();
                PsiMember original = member == null ? null : (PsiMember)branch.findOriginalPsi((PsiElement)member);
                return original == null ? null : SmartPointerManager.createPointer((PsiElement)original);
            }).toMap());
        });
    }

    private Map<PsiMember, SmartPsiElementPointer<PsiMember>> performMove(PsiClass targetClass, Set<PsiMember> membersToMove, List<MoveMembersUsageInfo> usages) {
        HashMap<PsiMember, SmartPsiElementPointer> anchors = new HashMap<PsiMember, SmartPsiElementPointer>();
        HashMap<PsiMember, PsiMember> anchorsInSourceClass = new HashMap<PsiMember, PsiMember>();
        for (PsiMember psiMember : membersToMove) {
            MoveMemberHandler moveMemberHandler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(psiMember.getLanguage());
            if (moveMemberHandler == null) continue;
            PsiElement anchor = moveMemberHandler.getAnchor(psiMember, targetClass, membersToMove);
            if (anchor instanceof PsiMember && membersToMove.contains((PsiMember)anchor)) {
                anchorsInSourceClass.put(psiMember, (PsiMember)anchor);
                continue;
            }
            anchors.put(psiMember, anchor == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(anchor));
        }
        ArrayList<MoveMembersUsageInfo> otherUsages = new ArrayList<MoveMembersUsageInfo>();
        for (MoveMembersUsageInfo moveMembersUsageInfo : usages) {
            MoveMemberHandler handler2;
            if (!moveMembersUsageInfo.reference.isValid() || (handler2 = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(moveMembersUsageInfo.getElement().getLanguage())) != null && handler2.changeExternalUsage(this.myOptions, moveMembersUsageInfo)) continue;
            otherUsages.add(moveMembersUsageInfo);
        }
        HashMap<PsiMember, SmartPsiElementPointer<PsiMember>> hashMap = new HashMap<PsiMember, SmartPsiElementPointer<PsiMember>>();
        for (PsiMember member : membersToMove) {
            PsiMember memberInSourceClass;
            ArrayList<PsiReference> refsToBeRebind = new ArrayList<PsiReference>();
            Iterator iterator = otherUsages.iterator();
            while (iterator.hasNext()) {
                MoveMembersUsageInfo info = (MoveMembersUsageInfo)((Object)iterator.next());
                if (!member.equals(info.member)) continue;
                PsiReference ref = info.getReference();
                if (ref != null) {
                    refsToBeRebind.add(ref);
                }
                iterator.remove();
            }
            this.getTransaction().getElementListener((PsiElement)member);
            MoveMemberHandler handler3 = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler3 == null) continue;
            SmartPsiElementPointer anchor = anchorsInSourceClass.containsKey(member) ? ((memberInSourceClass = (PsiMember)anchorsInSourceClass.get(member)) != null ? (SmartPsiElementPointer)hashMap.get(memberInSourceClass) : null) : (SmartPsiElementPointer)anchors.get(member);
            PsiMember newMember = handler3.doMove(this.myOptions, member, anchor == null ? null : anchor.getElement(), targetClass);
            hashMap.put(member, (SmartPsiElementPointer<PsiMember>)SmartPointerManager.createPointer((PsiElement)newMember));
            this.fixModifierList(member, newMember, usages);
            for (PsiReference reference : refsToBeRebind) {
                try {
                    reference.bindToElement((PsiElement)newMember);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        MoveMemberHandler moveMemberHandler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(targetClass.getLanguage());
        if (moveMemberHandler != null) {
            moveMemberHandler.decodeContextInfo((PsiElement)targetClass);
        }
        return hashMap;
    }

    private void afterAllMovements(Map<PsiMember, SmartPsiElementPointer<PsiMember>> movedMembers) {
        PsiMember item;
        for (Map.Entry<PsiMember, SmartPsiElementPointer<PsiMember>> entry : movedMembers.entrySet()) {
            PsiMember newMember = (PsiMember)entry.getValue().getElement();
            if (newMember == null) continue;
            PsiMember oldMember = entry.getKey();
            this.getTransaction().getElementListener((PsiElement)oldMember).elementMoved((PsiElement)newMember);
        }
        this.myMembersToMove.clear();
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
        if (this.myOpenInEditor && (item = (PsiMember)JBIterable.from(movedMembers.values()).map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).first()) != null) {
            EditorHelper.openInEditor((PsiElement)item);
        }
    }

    private void fixModifierList(PsiMember member, PsiMember newMember, List<MoveMembersUsageInfo> usages) throws IncorrectOperationException {
        PsiModifierList modifierList = newMember.getModifierList();
        if (modifierList != null && this.myTargetClass.isInterface()) {
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty("protected", false);
            modifierList.setModifierProperty("private", false);
            if (newMember instanceof PsiClass) {
                modifierList.setModifierProperty("static", false);
            }
            return;
        }
        if (this.myNewVisibility == null) {
            return;
        }
        ArrayList<MoveMembersUsageInfo> filtered = new ArrayList<MoveMembersUsageInfo>();
        for (MoveMembersUsageInfo usage : usages) {
            if (member != usage.member) continue;
            filtered.add(usage);
        }
        UsageInfo[] infos = filtered.toArray(UsageInfo.EMPTY_ARRAY);
        VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements((UsageInfo[])infos), (PsiMember)newMember, (String)this.myNewVisibility);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        String newVisibility = this.myOptions.getExplicitMemberVisibility();
        HashMap<PsiMember, PsiModifierList> modifierListCopies = new HashMap<PsiMember, PsiModifierList>();
        for (PsiMember member : this.myMembersToMove) {
            PsiModifierList modifierListCopy = member.getModifierList();
            if (modifierListCopy != null) {
                modifierListCopy = (PsiModifierList)modifierListCopy.copy();
            }
            if (modifierListCopy != null && newVisibility != null) {
                try {
                    VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)newVisibility);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            modifierListCopies.put(member, modifierListCopy);
        }
        MoveMembersProcessor.analyzeConflictsOnUsages(usages, this.myMembersToMove, this.myTargetClass, modifierListCopies, this.myOptions, (MultiMap<PsiElement, String>)conflicts);
        MoveMembersProcessor.analyzeConflictsOnMembers(this.myMembersToMove, newVisibility, this.myTargetClass, modifierListCopies, (MultiMap<PsiElement, String>)conflicts);
        RefactoringConflictsUtil.analyzeModuleConflicts(this.myProject, this.myMembersToMove, usages, (PsiElement)this.myTargetClass, (MultiMap<PsiElement, String>)conflicts);
        return this.showConflicts(conflicts, usages);
    }

    private static void analyzeConflictsOnUsages(UsageInfo[] usages, Set<PsiMember> membersToMove, @NotNull PsiClass targetClass, Map<PsiMember, PsiModifierList> modifierListCopies, MoveMembersOptions options, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveMembersUsageInfo)) continue;
            MoveMembersUsageInfo usageInfo = (MoveMembersUsageInfo)usage;
            PsiMember member = usageInfo.member;
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler == null) continue;
            handler.checkConflictsOnUsage(usageInfo, modifierListCopies.get(member), targetClass, membersToMove, options, conflicts);
        }
    }

    private static void analyzeConflictsOnMembers(Set<PsiMember> membersToMove, String newVisibility, PsiClass targetClass, Map<PsiMember, PsiModifierList> modifierListCopies, MultiMap<PsiElement, String> conflicts) {
        for (PsiMember member : membersToMove) {
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler == null) continue;
            handler.checkConflictsOnMember(member, newVisibility, modifierListCopies.get(member), targetClass, membersToMove, conflicts);
        }
    }

    public void doRun() {
        if (this.myMembersToMove.isEmpty()) {
            String message2 = RefactoringBundle.message((String)"no.members.selected");
            CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message2, (String)"refactoring.moveMembers", (Project)this.myProject);
            return;
        }
        super.doRun();
    }

    public List<PsiElement> getMembers() {
        return new ArrayList<PsiMember>(this.myMembersToMove);
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public static class MoveMembersUsageInfo
    extends MoveRenameUsageInfo {
        public final PsiClass qualifierClass;
        public final PsiElement reference;
        public final PsiMember member;

        public MoveMembersUsageInfo(PsiMember member, PsiElement element, PsiClass qualifierClass, PsiElement highlightElement, PsiReference ref) {
            super(highlightElement, ref, (PsiElement)member);
            this.member = member;
            this.qualifierClass = qualifierClass;
            this.reference = element;
        }

        @NotNull
        MoveMembersUsageInfo branched(ModelBranch branch) {
            PsiElement element = branch.obtainPsiCopy(this.reference);
            PsiElement highlightElement = this.getElement();
            PsiReference psiReference = this.getReference();
            return new MoveMembersUsageInfo((PsiMember)branch.findPsiCopy((PsiElement)this.member), element, this.qualifierClass == null ? null : (PsiClass)branch.findPsiCopy((PsiElement)this.qualifierClass), highlightElement == null ? null : branch.findPsiCopy(highlightElement), psiReference == null ? null : (PsiReference)branch.findReferenceCopy((PsiSymbolReference)psiReference));
        }
    }
}

