/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveMembers.MoveMembersImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveMembersHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (MoveMembersHandler.isFieldOrStaticMethod(element)) continue;
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PsiClass && !(targetElement instanceof PsiAnonymousClass);
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        MoveMembersImpl.doMove(project, elements, targetContainer, callback);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (MoveMembersHandler.isFieldOrStaticMethod(element)) {
            MoveMembersImpl.doMove(project, new PsiElement[]{element}, null, null);
            return true;
        }
        return false;
    }

    private static boolean isFieldOrStaticMethod(PsiElement element) {
        if (element instanceof PsiField) {
            return true;
        }
        if (element instanceof PsiMethod) {
            if (element instanceof SyntheticElement) {
                return false;
            }
            return ((PsiMethod)element).hasModifierProperty("static");
        }
        return false;
    }

    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        return JavaRefactoringBundle.message((String)"move.members.action.name", (Object[])new Object[0]);
    }

    public boolean supportsLanguage(@NotNull Language language) {
        return language instanceof JvmLanguage;
    }
}

